/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.ProgressEvent;
import org.jboss.deployers.spi.management.deploy.ProgressListener;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapterFactory;
import org.rhq.plugins.jbossas5.connection.AbstractProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.LocalProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.connection.RemoteProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DebugUtils;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServerComponent
implements ResourceComponent,
ProfileServiceComponent,
CreateChildResourceFacet,
MeasurementFacet,
ConfigurationFacet,
ProgressListener {
    private static final String MANAGED_PROPERTY_GROUP = "managedPropertyGroup";
    private static final Pattern METRIC_NAME_PATTERN = Pattern.compile("(.*)\\|(.*)\\|(.*)\\|(.*)");
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext resourceContext;
    private ProfileServiceConnection connection;
    private File deployDirectory;

    public AvailabilityType getAvailability() {
        this.connect();
        return this.connection != null ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void start(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
        this.connect();
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        ManagementView managementView = this.getConnection().getManagementView();
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            try {
                Matcher matcher = METRIC_NAME_PATTERN.matcher(metricName);
                if (!matcher.matches()) {
                    this.log.error((Object)("Metric name '" + metricName + "' does not match pattern '" + METRIC_NAME_PATTERN + "'."));
                    continue;
                }
                String componentCategory = matcher.group(1);
                String componentSubType = matcher.group(2);
                String componentName = matcher.group(3);
                String propertyName = matcher.group(4);
                ComponentType componentType = new ComponentType(componentCategory, componentSubType);
                ManagedComponent component = componentName.equals("*") ? ManagedComponentUtils.getSingletonManagedComponent(managementView, componentType) : ManagedComponentUtils.getManagedComponent(managementView, componentType, componentName);
                Serializable value = ManagedComponentUtils.getSimplePropertyValue(component, propertyName);
                if (value == null) {
                    this.log.debug((Object)("Null value returned for metric '" + metricName + "'."));
                    continue;
                }
                if (request.getDataType() == DataType.MEASUREMENT) {
                    Number number = (Number)value;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(number.doubleValue())));
                    continue;
                }
                if (request.getDataType() != DataType.TRAIT) continue;
                report.addData(new MeasurementDataTrait(request, value.toString()));
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Failed to obtain metric '" + metricName + "'."), (Throwable)e);
            }
        }
    }

    public Configuration loadResourceConfiguration() {
        return null;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
    }

    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        ResourceType resourceType = createResourceReport.getResourceType();
        if (resourceType.getCreationDataType() == ResourceCreationDataType.CONTENT) {
            this.createContentBasedResource(createResourceReport, resourceType);
        } else {
            this.createConfigurationBasedResource(createResourceReport, resourceType);
        }
        return createResourceReport;
    }

    public File getDeployDirectory() {
        if (this.deployDirectory == null) {
            this.deployDirectory = this.computeDeployDirectory();
        }
        return this.deployDirectory;
    }

    public void progressEvent(ProgressEvent eventInfo) {
        this.log.debug((Object)eventInfo);
    }

    @Override
    @Nullable
    public ProfileServiceConnection getConnection() {
        this.connect();
        return this.connection;
    }

    private void connect() {
        AbstractProfileServiceConnectionProvider connectionProvider;
        if (this.connection != null) {
            return;
        }
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String namingURL = pluginConfig.getSimpleValue("namingURL", null);
        if (namingURL != null) {
            ApplicationServerComponent.validateNamingURL(namingURL);
            String principal = pluginConfig.getSimpleValue("principal", null);
            String credentials = pluginConfig.getSimpleValue("credentials", null);
            connectionProvider = new RemoteProfileServiceConnectionProvider(namingURL, principal, credentials);
        } else {
            connectionProvider = new LocalProfileServiceConnectionProvider();
        }
        try {
            this.connection = connectionProvider.connect();
        }
        catch (RuntimeException e) {
            this.log.debug((Object)"Failed to connect to Profile Service.", (Throwable)e);
        }
    }

    private void handleMiscManagedProperties(Collection<PropertyDefinition> managedPropertyGroup, Map<String, ManagedProperty> managedProperties, Configuration pluginConfiguration) {
        for (PropertyDefinition propertyDefinition : managedPropertyGroup) {
            String propertyKey = propertyDefinition.getName();
            Property property = pluginConfiguration.get(propertyKey);
            ManagedProperty managedProperty = managedProperties.get(propertyKey);
            if (managedProperty == null || property == null) continue;
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(managedProperty.getMetaType());
            propertyAdapter.populateMetaValueFromProperty(property, managedProperty.getValue(), propertyDefinition);
        }
    }

    private static String getResourceName(Configuration pluginConfig, Configuration resourceConfig) {
        PropertySimple resourceNameProp = pluginConfig.getSimple("resourceName");
        if (resourceNameProp == null || resourceNameProp.getStringValue() == null) {
            throw new IllegalStateException("Property [resourceName] is not defined in the default plugin configuration.");
        }
        String resourceNamePropName = resourceNameProp.getStringValue();
        PropertySimple propToUseAsResourceName = resourceConfig.getSimple(resourceNamePropName);
        if (propToUseAsResourceName == null) {
            throw new IllegalStateException("Property [" + resourceNamePropName + "] is not defined in initial Resource configuration.");
        }
        return propToUseAsResourceName.getStringValue();
    }

    private String getResourceKey(ResourceType resourceType, String resourceName) {
        ComponentType componentType = ConversionUtils.getComponentType(resourceType);
        if (componentType == null) {
            throw new IllegalStateException("Unable to map " + resourceType + " to a ComponentType.");
        }
        return componentType.getType() + ":" + componentType.getSubtype() + ":" + resourceName;
    }

    private void createConfigurationBasedResource(CreateResourceReport createResourceReport, ResourceType resourceType) {
        Configuration defaultPluginConfig = ApplicationServerComponent.getDefaultPluginConfiguration(resourceType);
        Configuration resourceConfig = createResourceReport.getResourceConfiguration();
        String resourceName = ApplicationServerComponent.getResourceName(defaultPluginConfig, resourceConfig);
        ComponentType componentType = ConversionUtils.getComponentType(resourceType);
        ManagementView managementView = this.getConnection().getManagementView();
        if (ManagedComponentUtils.isManagedComponent(managementView, resourceName, componentType)) {
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("A " + resourceType.getName() + " named '" + resourceName + "' already exists.");
            return;
        }
        createResourceReport.setResourceName(resourceName);
        String resourceKey = this.getResourceKey(resourceType, resourceName);
        createResourceReport.setResourceKey(resourceKey);
        PropertySimple templateNameProperty = defaultPluginConfig.getSimple("templateName");
        String templateName = templateNameProperty.getStringValue();
        try {
            DeploymentTemplateInfo template = managementView.getTemplate(templateName);
            Map managedProperties = template.getProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(defaultPluginConfig);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("BEFORE CREATE:\n" + DebugUtils.convertPropertiesToString(template)));
            }
            ConversionUtils.convertConfigurationToManagedProperties(managedProperties, resourceConfig, resourceType, customProps);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("AFTER CREATE:\n" + DebugUtils.convertPropertiesToString(template)));
            }
            ConfigurationDefinition pluginConfigDef = resourceType.getPluginConfigurationDefinition();
            List managedPropertyGroup = pluginConfigDef.getPropertiesInGroup(MANAGED_PROPERTY_GROUP);
            this.handleMiscManagedProperties(managedPropertyGroup, managedProperties, defaultPluginConfig);
            this.log.debug((Object)("Applying template [" + templateName + "] to create ManagedComponent of type [" + componentType + "]..."));
            try {
                managementView.applyTemplate(resourceName, template);
                managementView.process();
                createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to apply template [" + templateName + "] to create ManagedComponent of type " + componentType + "."), (Throwable)e);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setException((Throwable)e);
            }
        }
        catch (NoSuchDeploymentException e) {
            this.log.error((Object)("Unable to find template [" + templateName + "]."), (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to process create request", (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
    }

    private void createContentBasedResource(CreateResourceReport createResourceReport, ResourceType resourceType) {
        ResourcePackageDetails details = createResourceReport.getPackageDetails();
        PackageDetailsKey key = details.getKey();
        String archivePath = key.getName();
        try {
            File archiveFile = new File(archivePath);
            if (!DeploymentUtils.hasCorrectExtension(archiveFile, resourceType)) {
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setErrorMessage("Incorrect extension specified on filename [" + archivePath + "]");
                return;
            }
            this.abortIfApplicationAlreadyDeployed(resourceType, archiveFile);
            Configuration deployTimeConfig = details.getDeploymentTimeConfiguration();
            boolean deployExploded = deployTimeConfig.getSimple("deployExploded").getBooleanValue();
            DeploymentManager deploymentManager = this.getConnection().getDeploymentManager();
            DeploymentStatus status = DeploymentUtils.deployArchive(deploymentManager, archiveFile, this.getDeployDirectory(), deployExploded);
            if (status.getState() == DeploymentStatus.StateType.COMPLETED) {
                createResourceReport.setResourceName(archivePath);
                createResourceReport.setResourceKey(archivePath);
                createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            } else {
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setErrorMessage(status.getMessage());
                createResourceReport.setException((Throwable)status.getFailure());
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Error deploying application for report: " + createResourceReport), t);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException(t);
        }
    }

    private static Configuration getDefaultPluginConfiguration(ResourceType resourceType) {
        ConfigurationTemplate pluginConfigDefaultTemplate = resourceType.getPluginConfigurationDefinition().getDefaultTemplate();
        return pluginConfigDefaultTemplate != null ? pluginConfigDefaultTemplate.createConfiguration() : new Configuration();
    }

    private void abortIfApplicationAlreadyDeployed(ResourceType resourceType, File archiveFile) throws Exception {
        String archiveFileName = archiveFile.getName();
        KnownDeploymentTypes deploymentType = ConversionUtils.getDeploymentType(resourceType);
        String deploymentTypeString = deploymentType.getType();
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.load();
        Set managedDeployments = managementView.getDeploymentsForType(deploymentTypeString);
        for (ManagedDeployment managedDeployment : managedDeployments) {
            if (!managedDeployment.getSimpleName().equals(archiveFileName)) continue;
            throw new IllegalArgumentException("An application named '" + archiveFileName + "' is already deployed.");
        }
    }

    private File computeDeployDirectory() {
        URL warUrl;
        Set warDeployments;
        ManagementView managementView = this.getConnection().getManagementView();
        try {
            warDeployments = managementView.getDeploymentsForType(KnownDeploymentTypes.JavaEEWebApplication.getType());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        ManagedDeployment standaloneWarDeployment = null;
        for (ManagedDeployment warDeployment : warDeployments) {
            if (warDeployment.getParent() != null) continue;
            standaloneWarDeployment = warDeployment;
            break;
        }
        if (standaloneWarDeployment == null) {
            return null;
        }
        this.log.debug((Object)("Standalone WAR deployment: " + standaloneWarDeployment.getName()));
        try {
            warUrl = new URL(standaloneWarDeployment.getName());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        File warFile = new File(warUrl.getPath());
        File deployDir = warFile.getParentFile();
        this.log.debug((Object)(">>>>> Deploy directory: " + deployDir));
        return deployDir;
    }

    @NotNull
    static File resolvePathRelativeToHomeDir(Configuration pluginConfig, @NotNull String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            String homeDir = pluginConfig.getSimple("homeDir").getStringValue();
            configDir = new File(homeDir, path);
        }
        return configDir;
    }

    private static void validateNamingURL(String namingURL) {
        URI namingURI;
        try {
            namingURI = new URI(namingURL);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Naming URL '" + namingURL + "' is not valid: " + e.getLocalizedMessage());
        }
        if (!namingURI.isAbsolute()) {
            throw new RuntimeException("Naming URL '" + namingURL + "' is not absolute.");
        }
        if (!namingURI.getScheme().equals("jnp")) {
            throw new RuntimeException("Naming URL '" + namingURL + "' has an invalid protocol - the only valid protocol is 'jnp'.");
        }
    }

    static abstract class PluginConfigPropNames {
        static final String SERVER_NAME = "serverName";
        static final String NAMING_URL = "namingURL";
        static final String PRINCIPAL = "principal";
        static final String CREDENTIALS = "credentials";
        static final String HOME_DIR = "homeDir";
        static final String SERVER_HOME_DIR = "serverHomeDir";
        static final String JAVA_HOME = "javaHome";
        static final String BIND_ADDRESS = "bindAddress";

        PluginConfigPropNames() {
        }
    }
}

