/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployers;

import java.io.File;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.aop.asintegration.core.AspectManagerServiceDelegate;
import org.jboss.logging.Logger;

public abstract class AbstractAspectManager {
    static final String BASE_ASPECTS_XML = "base-aspects.xml";
    static final boolean REGISTER_AFTER_START = true;
    private AspectManagerServiceDelegate delegate = this.createDelegate();

    public AbstractAspectManager(String bootstrapXml) {
        this.delegate.setAspectManager(AspectManager.getTopLevelAspectManager());
        this.delegate.setBootstrapXml(bootstrapXml);
        this.delegate.setBaseXml(BASE_ASPECTS_XML);
        this.delegate.setRegisterHappensAfterStart(true);
    }

    public AspectManager getAspectManager() {
        return AspectManager.getTopLevelAspectManager();
    }

    protected abstract AspectManagerServiceDelegate createDelegate();

    public AspectManagerServiceDelegate getDelegate() {
        return this.delegate;
    }

    public String aspectDefinitions() {
        return this.delegate.aspectDefinitions();
    }

    public String bindings() {
        return this.delegate.bindings();
    }

    public void create() throws Exception {
        this.delegate.create();
    }

    public void start() throws Exception {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public boolean getEnableLoadtimeWeaving() {
        return this.delegate.getEnableLoadtimeWeaving();
    }

    public boolean getEnableTransformer() {
        return this.delegate.getEnableTransformer();
    }

    public String getExclude() {
        return this.delegate.getExclude();
    }

    public String getIgnore() {
        return this.delegate.getIgnore();
    }

    public String getInclude() {
        return this.delegate.getInclude();
    }

    public String getIncludedInvisibleAnnotations() {
        return this.delegate.getIncludedInvisibleAnnotations();
    }

    public String getInstrumentor() {
        return this.delegate.getInstrumentor();
    }

    public Logger getLog() {
        return this.delegate.getLog();
    }

    public boolean getOptimized() {
        return this.delegate.getOptimized();
    }

    public boolean getPrune() {
        return this.delegate.getPrune();
    }

    public boolean getSuppressReferenceErrors() {
        return this.delegate.getSuppressReferenceErrors();
    }

    public boolean getSuppressTransformationErrors() {
        return this.delegate.getSuppressTransformationErrors();
    }

    public File getTmpClassesDir() {
        return this.delegate.getTmpClassesDir();
    }

    public boolean getVerbose() {
        return this.delegate.getVerbose();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String interceptorFactories() {
        return this.delegate.interceptorFactories();
    }

    public String introductions() {
        return this.delegate.introductions();
    }

    public String registeredClassLoaders() {
        return this.delegate.registeredClassLoaders();
    }

    public void setEnableLoadtimeWeaving(boolean enableTransformer) {
        this.delegate.setEnableLoadtimeWeaving(enableTransformer);
    }

    public void setEnableTransformer(boolean enableTransformer) {
        this.delegate.setEnableTransformer(enableTransformer);
    }

    public void setExclude(String exclude) {
        this.delegate.setExclude(exclude);
    }

    public void setIgnore(String ignore) {
        this.delegate.setIgnore(ignore);
    }

    public void setInclude(String include) {
        this.delegate.setInclude(include);
    }

    public void setIncludedInvisibleAnnotations(String iia) {
        this.delegate.setIncludedInvisibleAnnotations(iia);
    }

    public void setInstrumentor(String instrumentor) {
        this.delegate.setInstrumentor(instrumentor);
    }

    public void setOptimized(boolean verbose) {
        this.delegate.setOptimized(verbose);
    }

    public void setPrune(boolean prune) {
        this.delegate.setPrune(prune);
    }

    public void setSuppressReferenceErrors(boolean suppressReferenceErrors) {
        this.delegate.setSuppressReferenceErrors(suppressReferenceErrors);
    }

    public void setSuppressTransformationErrors(boolean suppressTransformationErrors) {
        this.delegate.setSuppressTransformationErrors(suppressTransformationErrors);
    }

    public void setTmpClassesDir(File tmpClassesDir) {
        this.delegate.setTmpClassesDir(tmpClassesDir);
    }

    public void setVerbose(boolean verbose) {
        this.delegate.setVerbose(verbose);
    }

    public String stacks() {
        return this.delegate.stacks();
    }

    public void deployBaseAspects() {
        this.delegate.deployBaseXml();
    }

    public void undeployBaseAspects() {
        this.delegate.undeployBaseXml();
    }

    public boolean getUseBaseXml() {
        return this.delegate.getUseBaseXml();
    }

    public synchronized void setUseBaseXml(boolean useBaseXml) {
        this.delegate.setUseBaseXml(useBaseXml);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public JBossIntegration getJbossIntegration() {
        return this.delegate.getJBossIntegration();
    }

    public void setJbossIntegration(JBossIntegration integration) {
        this.delegate.setJBossIntegration(integration);
    }
}

