/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement.composite;

import java.io.Serializable;
import org.rhq.core.domain.measurement.MeasurementBaseline;

public class MeasurementBaselineComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final double min;
    private final double max;
    private final double mean;
    private final int scheduleId;

    public MeasurementBaselineComposite(int id, double min, double max, double mean, int scheduleId) {
        this.id = id;
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.scheduleId = scheduleId;
    }

    public MeasurementBaselineComposite(MeasurementBaseline baseline) {
        this.id = baseline.getId();
        this.min = baseline.getMin();
        this.max = baseline.getMax();
        this.mean = baseline.getMean();
        this.scheduleId = baseline.getSchedule().getId();
    }

    public int getId() {
        return this.id;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }
}

