/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.microcontainer.beans.MixinEntry;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroductionBinding {
    protected AspectManager manager;
    protected String name;
    protected String classes;
    protected String expr;
    protected List<String> interfaces;
    protected List<MixinEntry> mixins;

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public List<MixinEntry> getMixins() {
        return this.mixins;
    }

    public void setMixins(List<MixinEntry> mixins) {
        this.mixins = mixins;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClasses() {
        return this.classes;
    }

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public void start() throws Exception {
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.classes == null && this.expr == null) {
            throw new IllegalArgumentException("Neither classes nor expr set");
        }
        if (this.classes != null && this.expr != null) {
            throw new IllegalArgumentException("Cannot set both classes and expr");
        }
        if (this.interfaces == null && this.mixins == null) {
            throw new IllegalArgumentException("Neither interfaces nor mixins set");
        }
        if (this.name == null) {
            this.name = GUID.asString();
        }
        String[] intfs = this.interfaces != null ? this.interfaces.toArray(new String[this.interfaces.size()]) : null;
        InterfaceIntroduction introduction = null;
        if (this.classes != null) {
            introduction = new InterfaceIntroduction(this.name, this.classes, intfs);
        } else {
            ASTStart start = new TypeExpressionParser((Reader)new StringReader(this.expr)).Start();
            introduction = new InterfaceIntroduction(this.name, start, intfs);
        }
        if (this.mixins != null) {
            for (MixinEntry entry : this.mixins) {
                if (entry.getInterfaces() == null) {
                    throw new IllegalArgumentException("MixinEntry with null interfaces");
                }
                if (entry.getMixin() == null) {
                    throw new IllegalArgumentException("MixinEntry with null mixin");
                }
                String[] intfaces = entry.getInterfaces().toArray(new String[entry.getInterfaces().size()]);
                introduction.addMixin(new InterfaceIntroduction.Mixin(entry.getMixin(), intfaces, entry.getConstruction(), entry.isTransient()));
            }
        }
        this.manager.addInterfaceIntroduction(introduction);
    }

    public void stop() throws Exception {
        this.manager.removeInterfaceIntroduction(this.name);
    }
}

