/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.alert.AlertDefinition;

@DiscriminatorColumn(name="NOTIFICATION_TYPE", discriminatorType=DiscriminatorType.STRING)
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@NamedQueries(value={@NamedQuery(name="AlertNotification.deleteById", query="DELETE FROM AlertNotification an WHERE an.id IN ( :ids )"), @NamedQuery(name="AlertNotification.deleteByResources", query="DELETE FROM AlertNotification an WHERE an.alertDefinition IN ( SELECT ad FROM AlertDefinition ad WHERE ad.resource IN (:resources))"), @NamedQuery(name="AlertNotification.deleteOrphaned", query="DELETE FROM AlertNotification an WHERE an.alertDefinition IS NULL")})
@SequenceGenerator(name="RHQ_ALERT_NOTIFICATION_ID_SEQ", sequenceName="RHQ_ALERT_NOTIFICATION_ID_SEQ")
@Table(name="RHQ_ALERT_NOTIFICATION")
public abstract class AlertNotification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELETE_BY_ID = "AlertNotification.deleteById";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertNotification.deleteByResources";
    public static final String QUERY_DELETE_ORPHANED = "AlertNotification.deleteOrphaned";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RHQ_ALERT_NOTIFICATION_ID_SEQ")
    @Id
    private int id;
    @JoinColumn(name="ALERT_DEFINITION_ID")
    @ManyToOne
    private AlertDefinition alertDefinition;

    protected AlertNotification() {
    }

    public AlertNotification(@NotNull AlertDefinition alertDefinition) {
        if (alertDefinition == null) {
            throw new IllegalArgumentException("alertDefinition must be non-null.");
        }
        this.alertDefinition = alertDefinition;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public AlertDefinition getAlertDefinition() {
        return this.alertDefinition;
    }

    public void setAlertDefinition(AlertDefinition alertDefinition) {
        this.alertDefinition = alertDefinition;
    }

    public abstract AlertNotification copy();
}

