/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.tx;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.transaction.xa.Xid;
import org.jboss.jms.tx.ClientTransaction;
import org.jboss.jms.tx.MessagingXid;
import org.jboss.messaging.util.Streamable;

public class TransactionRequest
implements Streamable {
    public static final byte ONE_PHASE_COMMIT_REQUEST = 0;
    public static final byte TWO_PHASE_PREPARE_REQUEST = 2;
    public static final byte TWO_PHASE_COMMIT_REQUEST = 3;
    public static final byte TWO_PHASE_ROLLBACK_REQUEST = 4;
    private static final byte PRESENT = 1;
    private static final byte NULL = 0;
    protected int requestType;
    protected Xid xid;
    protected ClientTransaction state;

    public TransactionRequest() {
    }

    public TransactionRequest(int requestType, Xid xid, ClientTransaction state) {
        this.requestType = requestType;
        this.xid = xid;
        this.state = state;
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.requestType);
        if (this.xid == null) {
            out.writeByte(0);
        } else {
            byte[] branchQual = this.xid.getBranchQualifier();
            int formatId = this.xid.getFormatId();
            byte[] globalTxId = this.xid.getGlobalTransactionId();
            out.write(1);
            out.writeInt(branchQual.length);
            out.write(branchQual);
            out.writeInt(formatId);
            out.writeInt(globalTxId.length);
            out.write(globalTxId);
        }
        if (this.state != null) {
            out.write(1);
            this.state.write(out);
        } else {
            out.write(0);
        }
    }

    public void read(DataInputStream in) throws Exception {
        this.requestType = in.readInt();
        byte isXid = in.readByte();
        if (isXid == 0) {
            this.xid = null;
        } else if (isXid == 1) {
            int l = in.readInt();
            byte[] branchQual = new byte[l];
            in.readFully(branchQual);
            int formatId = in.readInt();
            l = in.readInt();
            byte[] globalTxId = new byte[l];
            in.readFully(globalTxId);
            this.xid = new MessagingXid(branchQual, formatId, globalTxId);
        } else {
            throw new IllegalStateException("Invalid value:" + isXid);
        }
        byte isState = in.readByte();
        if (isState == 0) {
            this.state = null;
        } else {
            this.state = new ClientTransaction();
            this.state.read(in);
        }
    }

    public ClientTransaction getState() {
        return this.state;
    }

    public Xid getXid() {
        return this.xid;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public String toString() {
        return "TransactionRequest[" + (this.requestType == 0 ? "ONE_PHASE_COMMIT" : (this.requestType == 2 ? "TWO_PHASE_PREPARE" : (this.requestType == 3 ? "TWO_PHASE_COMMIT" : (this.requestType == 4 ? "TWO_PHASE_ROLLBACK_" : "UNKNOW_REQUEST_TYPE")))) + ", " + this.xid + "]";
    }
}

