/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.definition.constraint;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import org.rhq.core.domain.configuration.definition.constraint.Constraint;

@DiscriminatorValue(value="FLOAT_RANGE")
@Entity
public class FloatRangeConstraint
extends Constraint {
    private static final String UNBOUNDED_SYMBOL = "*";
    private static final long serialVersionUID = 1L;
    @Transient
    private Double minimum;
    @Transient
    private Double maximum;

    public FloatRangeConstraint(Double minimum, Double maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.rebuildDetails();
    }

    protected FloatRangeConstraint() {
    }

    public void setDetails(String details) {
        super.setDetails(details);
        if (details != null) {
            this.splitAndPopulate();
        }
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
        this.rebuildDetails();
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
        this.rebuildDetails();
    }

    public Double getMaximum() {
        return this.maximum;
    }

    @PostLoad
    private void splitAndPopulate() {
        String[] split = this.details.split("#");
        assert (split != null && split.length == 2) : "DoubleRangeConstraint.setDetails - Details could not be split. Details: " + this.details;
        this.minimum = UNBOUNDED_SYMBOL.equals(split[0]) ? null : new Double(split[0]);
        this.maximum = UNBOUNDED_SYMBOL.equals(split[1]) ? null : new Double(split[1]);
    }

    private void rebuildDetails() {
        String min = this.minimum == null ? UNBOUNDED_SYMBOL : this.minimum.toString();
        String max = this.maximum == null ? UNBOUNDED_SYMBOL : this.maximum.toString();
        super.setDetails(min + "#" + max);
    }
}

