/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.config.LoggerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.util.ObjectUtil;

public class JacORBConfiguration
extends DefaultConfiguration
implements Configuration {
    private static final String CONFIG_LOG_VERBOSITY = "jacorb.config.log.verbosity";
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String EMPTY_STR = "";
    private static final int DEFAULT_LOG_LEVEL = 0;
    private final ORB orb;
    private Logger logger = null;
    private LoggerFactory loggerFactory = null;
    private static final String loggerFactoryClzName = "org.jacorb.config.LogKitLoggerFactory";

    public static Configuration getConfiguration(Properties properties, ORB oRB, boolean bl) throws ConfigurationException {
        String string;
        String string2 = "jacorb";
        String string3 = null;
        if (!bl) {
            try {
                string3 = System.getProperty("ORBid");
            }
            catch (SecurityException securityException) {
                bl = true;
                JacORBConfiguration.println("Could not access system property 'ORBid' - will use default...");
            }
        }
        if (properties != null && (string = (String)properties.get("ORBid")) != null) {
            string3 = string;
        }
        if (string3 != null) {
            if (string3.equals("orb") || string3.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + string3 + "> is reserved");
            }
            string2 = string3;
        }
        return new JacORBConfiguration(string2, properties, oRB, bl);
    }

    private JacORBConfiguration(String string, Properties properties, ORB oRB, boolean bl) throws ConfigurationException {
        super(string);
        this.orb = oRB;
        if (bl) {
            this.initApplet(string, properties);
        } else {
            this.init(string, properties);
        }
        this.initLogging();
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void printErr(String string) {
        System.err.println(string);
    }

    private void init(String string, Properties properties) throws ConfigurationException {
        List list;
        String string2;
        if (string == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String string3 = System.getProperty("file.separator");
        String string4 = System.getProperty("user.home");
        String string5 = System.getProperty("java.home");
        boolean bl = false;
        this.setAttributes(System.getProperties());
        int n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
        Properties properties2 = JacORBConfiguration.loadPropertiesFromFile(string5 + string3 + "lib" + string3 + COMMON_PROPS);
        if (properties2 != null) {
            this.setAttributes(properties2);
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            bl = true;
            if (n > 2) {
                JacORBConfiguration.println("[ base configuration loaded from file " + string5 + string3 + "lib" + string3 + COMMON_PROPS + " ]");
            }
        }
        if ((properties2 = JacORBConfiguration.loadPropertiesFromFile(string4 + string3 + COMMON_PROPS)) != null) {
            this.setAttributes(properties2);
            bl = true;
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 2) {
                JacORBConfiguration.println("[ base configuration loaded from file " + string4 + string3 + COMMON_PROPS + " ]");
            }
        }
        if ((properties2 = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            bl = true;
            this.setAttributes(properties2);
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 2) {
                JacORBConfiguration.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((string2 = this.getAttribute("jacorb.config.dir", EMPTY_STR)).length() == 0) {
            string2 = this.getAttribute("jacorb.home", EMPTY_STR);
        }
        if (string2.length() != 0) {
            string2 = string2 + string3 + "etc";
        } else {
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 0) {
                JacORBConfiguration.printErr("[ jacorb.home unset! Will use '.' ]");
            }
            string2 = ".";
        }
        String string6 = string2 + string3 + string + fileSuffix;
        Properties properties3 = JacORBConfiguration.loadPropertiesFromFile(string6);
        if (properties3 != null) {
            this.setAttributes(properties3);
            bl = true;
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 2) {
                JacORBConfiguration.println("[ configuration " + string + " loaded from file " + string6 + " ]");
            }
        } else {
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 0) {
                JacORBConfiguration.printErr("[ File " + string6 + " for configuration " + string + " not found ]");
            }
        }
        if ((properties3 = JacORBConfiguration.loadPropertiesFromClassPath(string + fileSuffix)) != null) {
            this.setAttributes(properties3);
            bl = true;
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 2) {
                JacORBConfiguration.println("[ configuration " + string + " loaded from classpath]");
            }
        }
        if (!(list = this.getAttributeList("custom.props")).isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                Properties properties4 = JacORBConfiguration.loadPropertiesFromFile(string7);
                if (properties4 != null) {
                    this.setAttributes(properties4);
                    bl = true;
                    n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
                    if (n <= 2) continue;
                    JacORBConfiguration.println("[ custom properties loaded from file " + string7 + " ]");
                    continue;
                }
                if (n <= 0) continue;
                JacORBConfiguration.printErr("[ custom properties not found in " + string7 + " ]");
            }
        }
        this.setAttributes(System.getProperties());
        if (properties != null) {
            bl = true;
            this.setAttributes(properties);
        }
        if (!bl && n > 0) {
            JacORBConfiguration.println("[ No configuration properties found for configuration " + string + " ]");
        }
    }

    private void initApplet(String string, Properties properties) throws ConfigurationException {
        List list;
        String string2;
        Properties properties2;
        if (string == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        boolean bl = false;
        if (properties != null) {
            this.setAttributes(properties);
        }
        int n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
        Properties properties3 = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS);
        if (properties3 != null) {
            bl = true;
            this.setAttributes(properties3);
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 2) {
                JacORBConfiguration.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((properties2 = JacORBConfiguration.loadPropertiesFromClassPath(string2 = string + fileSuffix)) != null) {
            this.setAttributes(properties2);
            bl = true;
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 2) {
                JacORBConfiguration.println("[ configuration " + string + " loaded from classpath " + string2 + " ]");
            }
        } else {
            n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (n > 0) {
                JacORBConfiguration.printErr("[ File " + string2 + " for configuration " + string + " not found in classpath]");
            }
        }
        if (!(list = this.getAttributeList("custom.props")).isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Properties properties4 = JacORBConfiguration.loadPropertiesFromClassPath(string3);
                if (properties4 != null) {
                    this.setAttributes(properties4);
                    bl = true;
                    n = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
                    if (n <= 2) continue;
                    JacORBConfiguration.println("[ custom properties loaded from classpath " + string3 + " ]");
                    continue;
                }
                if (n <= 0) continue;
                JacORBConfiguration.printErr("[ custom properties " + string3 + "not found in classpath ]");
            }
        }
        if (properties != null) {
            bl = true;
            this.setAttributes(properties);
        }
        if (!bl) {
            JacORBConfiguration.println("[ No configuration properties found for configuration " + string + " ]");
        }
    }

    void setAttributes(Properties properties) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Object object;
            Object object2 = iterator.next();
            if (!(object2 instanceof String) || !((object = properties.get(string = (String)object2)) instanceof String) && object != null) continue;
            this.setAttribute(string, (String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String string) {
        Properties properties;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            Properties properties2 = new Properties();
            properties2.load(fileInputStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                JacORBConfiguration.println("could not read config file: " + string);
                iOException.printStackTrace();
                return null;
            }
        }
        ((InputStream)fileInputStream).close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromClassPath(String string) {
        Properties properties;
        block6: {
            properties = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : JacORBConfiguration.class.getClassLoader();
                URL uRL = classLoader.getResource(string);
                if (uRL == null) break block6;
                properties = new Properties();
                InputStream inputStream = uRL.openStream();
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                JacORBConfiguration.println("could not read config file: " + string);
                iOException.printStackTrace();
            }
        }
        return properties;
    }

    private void initLogging() {
        Object object;
        String string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMdHm");
        String string2 = this.getAttribute("jacorb.logfile", EMPTY_STR);
        int n = this.getAttributeAsInteger("jacorb.logfile.maxLogSize", 0);
        if (!string2.equals(EMPTY_STR)) {
            if (this.orb == null) {
                string = this.getAttribute("jacorb.logfile.singleton", EMPTY_STR);
                if (string.equals(EMPTY_STR)) {
                    string2 = EMPTY_STR;
                } else if (string2.endsWith("$implname")) {
                    string2 = string2.substring(0, string2.indexOf("$implname") - 1);
                    string2 = string2 + File.separatorChar + string + simpleDateFormat.format(new Date()) + ".log";
                } else {
                    object = new File(string2);
                    String string3 = ((File)object).getParent();
                    string2 = string3 != null ? string2 + string + simpleDateFormat.format(new Date()) + ".log" : string + simpleDateFormat.format(new Date()) + ".log";
                }
            } else if (string2.endsWith("$implname")) {
                string2 = string2.substring(0, string2.length() - 9);
                string = new String(this.orb.getServerId());
                object = this.getAttribute("jacorb.implname", string);
                string2 = string2 + (String)object + ".log";
            }
        }
        string = this.getAttribute("jacorb.log.loggerFactory", EMPTY_STR);
        object = null;
        try {
            object = !string.equals(EMPTY_STR) ? ObjectUtil.classForName(string) : ObjectUtil.classForName(loggerFactoryClzName);
            this.loggerFactory = (LoggerFactory)((Class)object).newInstance();
            this.loggerFactory.configure(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.loggerFactory == null) {
            JacORBConfiguration.printErr("Configuration Error, could not create logger!");
        }
        if (!string2.equals(EMPTY_STR)) {
            try {
                this.loggerFactory.setDefaultLogFile(string2, n);
                this.logger = this.loggerFactory.getNamedLogger("jacorb", string2, n);
            }
            catch (IOException iOException) {
                this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create logger with file target: " + string2 + ", falling back to console log!");
                }
            }
        } else {
            this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
        }
    }

    public ORB getORB() {
        return this.orb;
    }

    public Logger getNamedLogger(String string) {
        return this.loggerFactory.getNamedLogger(string);
    }

    public String getLoggerName(Class clazz) {
        String string = clazz.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        if (string2 != null && string2.startsWith("org.jacorb")) {
            return string2.substring(4);
        }
        return string2;
    }

    public List getAttributeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        try {
            string2 = this.getAttribute(string);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public Object getAttributeAsObject(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string, null);
        if (string2 != null && string2.length() > 0) {
            return this.newInstance(string, string2);
        }
        return null;
    }

    private Object newInstance(String string, String string2) throws ConfigurationException {
        try {
            Class clazz = ObjectUtil.classForName(string2);
            Object t = clazz.newInstance();
            if (t instanceof Configurable) {
                ((Configurable)t).configure((org.apache.avalon.framework.configuration.Configuration)this);
            }
            return t;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to build class from key >" + string + "<: " + exception);
        }
    }

    public Object getAttributeAsObject(String string, String string2) throws ConfigurationException {
        Object object = this.getAttributeAsObject(string);
        if (object == null) {
            return this.newInstance("default", string2);
        }
        return object;
    }

    public boolean getAttributeAsBoolean(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        if (string2 != null && string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return false;
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        String string2 = this.getAttribute(string, EMPTY_STR);
        if (string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return bl;
    }

    public List getAttributeNamesWithPrefix(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            arrayList.add(stringArray[i]);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

