/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mortbay.cometd.MessagePool;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends HashMap<String, Object>
implements Message,
JSON.Generator {
    MessagePool _pool;
    String _clientId;
    String _json;
    String _channel;
    String _id;
    Object _data;
    Message _associated;
    AtomicInteger _refs = new AtomicInteger();

    public MessageImpl() {
        super(8);
    }

    public MessageImpl(MessagePool bayeux) {
        super(8);
        this._pool = bayeux;
    }

    public void incRef() {
        this._refs.getAndIncrement();
    }

    public void decRef() {
        int r = this._refs.decrementAndGet();
        if (r == 0 && this._pool != null) {
            this._pool.recycleMessage(this);
        } else if (r < 0) {
            throw new IllegalStateException();
        }
    }

    public String getChannel() {
        return this._channel;
    }

    public String getClientId() {
        if (this._clientId == null) {
            this._clientId = (String)this.get("clientId");
        }
        return this._clientId;
    }

    public String getId() {
        return this._id;
    }

    public Object getData() {
        return this._data;
    }

    public void addJSON(StringBuffer buffer) {
        buffer.append(this.getJSON());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJSON() {
        if (this._json == null) {
            StringBuffer buf;
            JSON json = this._pool == null ? JSON.getDefault() : this._pool.getMsgJSON();
            StringBuffer stringBuffer = buf = new StringBuffer(json.getStringBufferSize());
            synchronized (stringBuffer) {
                json.appendMap(buf, (Map)this);
                this._json = buf.toString();
            }
        }
        return this._json;
    }

    @Override
    public void clear() {
        this._json = null;
        this._id = null;
        this._channel = null;
        this._clientId = null;
        this.setAssociated(null);
        this._refs.set(0);
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if ("channel".equals(key)) {
                entry.setValue(null);
                continue;
            }
            if ("id".equals(key)) {
                entry.setValue(null);
                continue;
            }
            if ("timestamp".equals(key)) {
                entry.setValue(null);
                continue;
            }
            if ("data".equals(key)) {
                entry.setValue(null);
                continue;
            }
            iterator.remove();
        }
        super.clear();
    }

    @Override
    public Object put(String key, Object value) {
        this._json = null;
        if ("channel".equals(key)) {
            this._channel = (String)value;
        } else if ("id".equals(key)) {
            this._id = value.toString();
        } else if ("clientId".equals(key)) {
            this._clientId = (String)value;
        } else if ("data".equals(key)) {
            this._data = value;
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this._json = null;
        super.putAll(m);
        this._channel = (String)this.get("channel");
        Object id = this.get("id");
        this._id = id == null ? null : id.toString();
        this._data = this.get("data");
    }

    @Override
    public Object remove(Object key) {
        this._json = null;
        if ("channel".equals(key)) {
            this._channel = null;
        } else if ("id".equals(key)) {
            this._id = null;
        } else if ("data".equals(key)) {
            this._data = null;
        }
        return super.remove(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    public Message getAssociated() {
        return this._associated;
    }

    public void setAssociated(Message associated) {
        if (this._associated != associated) {
            if (this._associated != null) {
                ((MessageImpl)this._associated).decRef();
            }
            this._associated = associated;
            if (this._associated != null) {
                ((MessageImpl)this._associated).incRef();
            }
        }
    }
}

