/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;

public class ProxyingLinkRewriter
implements LinkRewriter {
    private final String prefix;
    private final Uri parsedPrefix;
    private final ContentRewriterFeature rewriterFeature;
    private final Uri gadgetUri;

    public ProxyingLinkRewriter(Uri gadgetUri, ContentRewriterFeature rewriterFeature, String prefix) {
        this.prefix = prefix;
        this.parsedPrefix = Uri.parse((String)prefix);
        this.rewriterFeature = rewriterFeature;
        this.gadgetUri = gadgetUri;
    }

    public String rewrite(String link, Uri context) {
        if ((link = link.trim()).length() == 0) {
            return link;
        }
        try {
            Uri linkUri = this.processLink(Uri.parse((String)link));
            Uri uri = context.resolve(linkUri);
            if (this.rewriterFeature.shouldRewriteURL(uri.toString())) {
                String result = this.prefix + Utf8UrlCoder.encode((String)uri.toString()) + (this.gadgetUri == null ? "" : "&gadget=" + Utf8UrlCoder.encode((String)this.gadgetUri.toString())) + "&fp=" + this.rewriterFeature.getFingerprint();
                if (this.rewriterFeature.getExpires() != null) {
                    result = result + "&refresh=" + this.rewriterFeature.getExpires().toString();
                }
                return result;
            }
            return uri.toString();
        }
        catch (IllegalArgumentException use) {
            return link;
        }
    }

    private Uri processLink(Uri original) {
        if (this.parsedPrefix.getPath().equals(original.getPath())) {
            return Uri.parse((String)original.getQueryParameter("url"));
        }
        return original;
    }
}

