/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.cloud.AffinityGroup;
import org.rhq.core.domain.cloud.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="Agent")
@NamedQueries(value={@NamedQuery(name="Agent.findByName", query="SELECT a FROM Agent a WHERE a.name = :name"), @NamedQuery(name="Agent.findByAddressAndPort", query="SELECT a FROM Agent a WHERE a.address = :address AND a.port = :port"), @NamedQuery(name="Agent.findByAgentToken", query="SELECT a FROM Agent a WHERE a.agentToken = :agentToken"), @NamedQuery(name="Agent.findByResourceId", query="SELECT r.agent FROM Resource r WHERE r.id = :resourceId"), @NamedQuery(name="Agent.findAgentIdByResourceId", query="SELECT r.agent.id FROM Resource r WHERE r.id = :resourceId"), @NamedQuery(name="Agent.findAgentIdByScheduleId", query="SELECT r.agent.id FROM MeasurementSchedule sched JOIN sched.resource r WHERE sched.id = :scheduleId"), @NamedQuery(name="Agent.findAll", query="SELECT a FROM Agent a"), @NamedQuery(name="Agent.findByServer", query="SELECT a FROM Agent a WHERE (a.server.id = :serverId OR :serverId IS NULL)"), @NamedQuery(name="Agent.removeServerReference", query="UPDATE Agent a SET a.server.id = NULL WHERE a.server.id = :serverId "), @NamedQuery(name="Agent.countAll", query="SELECT count(a.id) FROM Agent a"), @NamedQuery(name="Agent.findResourceIdsForAgent", query="SELECT r.id FROM Resource r WHERE r.agent.id = :agentId"), @NamedQuery(name="Agent.findAllSuspectAgents", query="SELECT new org.rhq.core.domain.resource.composite.AgentLastAvailabilityReportComposite        (           a.id,a.name,a.remoteEndpoint,a.lastAvailabilityReport        )   FROM Agent a  WHERE a.lastAvailabilityReport < :dateThreshold "), @NamedQuery(name="Agent.findAllWithStatusByServer", query="SELECT a.id   FROM Agent a  WHERE a.server.name = :serverName    AND a.status <> 0 "), @NamedQuery(name="Agent.findAllWithStatus", query="SELECT a.id   FROM Agent a  WHERE a.status <> 0 "), @NamedQuery(name="Agent.updateClearStatusByIds", query="UPDATE Agent a    SET a.status = 0  WHERE a.id IN ( :agentIds ) "), @NamedQuery(name="Agent.findByAffinityGroup", query="SELECT a   FROM Agent a  WHERE a.affinityGroup.id = :affinityGroupId "), @NamedQuery(name="Agent.findWithoutAffinityGroup", query="SELECT a   FROM Agent a  WHERE a.affinityGroup IS NULL")})
@SequenceGenerator(name="id", sequenceName="RHQ_AGENT_ID_SEQ")
@Table(name="RHQ_AGENT")
public class Agent
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_NAME = "Agent.findByName";
    public static final String QUERY_FIND_BY_ADDRESS_AND_PORT = "Agent.findByAddressAndPort";
    public static final String QUERY_FIND_BY_AGENT_TOKEN = "Agent.findByAgentToken";
    public static final String QUERY_FIND_BY_RESOURCE_ID = "Agent.findByResourceId";
    public static final String QUERY_FIND_AGENT_ID_BY_RESOURCE_ID = "Agent.findAgentIdByResourceId";
    public static final String QUERY_FIND_AGENT_ID_BY_SCHEDULE_ID = "Agent.findAgentIdByScheduleId";
    public static final String QUERY_FIND_ALL = "Agent.findAll";
    public static final String QUERY_FIND_BY_SERVER = "Agent.findByServer";
    public static final String QUERY_COUNT_ALL = "Agent.countAll";
    public static final String QUERY_FIND_RESOURCE_IDS_FOR_AGENT = "Agent.findResourceIdsForAgent";
    public static final String QUERY_FIND_ALL_SUSPECT_AGENTS = "Agent.findAllSuspectAgents";
    public static final String QUERY_FIND_BY_AFFINITY_GROUP = "Agent.findByAffinityGroup";
    public static final String QUERY_FIND_WITHOUT_AFFINITY_GROUP = "Agent.findWithoutAffinityGroup";
    public static final String QUERY_FIND_ALL_WITH_STATUS_BY_SERVER = "Agent.findAllWithStatusByServer";
    public static final String QUERY_FIND_ALL_WITH_STATUS = "Agent.findAllWithStatus";
    public static final String UPDATE_CLEAR_STATUS_BY_IDS = "Agent.updateClearStatusByIds";
    public static final String QUERY_REMOVE_SERVER_REFERENCE = "Agent.removeServerReference";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="id")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="ADDRESS", nullable=false)
    private String address;
    @Column(name="PORT", nullable=false)
    private int port;
    @Column(name="AGENTTOKEN", nullable=false)
    private String agentToken;
    @Column(name="REMOTE_ENDPOINT")
    private String remoteEndpoint;
    @Column(name="CTIME", nullable=false)
    private long ctime = System.currentTimeMillis();
    @Column(name="MTIME", nullable=false)
    private long mtime = System.currentTimeMillis();
    @Column(name="LAST_AVAILABILITY_REPORT")
    private Long lastAvailabilityReport;
    @JoinColumn(name="AFFINITY_GROUP_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    private AffinityGroup affinityGroup;
    @JoinColumn(name="SERVER_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    private Server server;
    @Column(name="STATUS", nullable=false)
    private int status;

    protected Agent() {
    }

    public Agent(@NotNull String name, String address, int port, String remoteEndpoint, String agentToken) {
        this.name = name;
        this.address = address;
        this.port = port;
        this.remoteEndpoint = remoteEndpoint;
        this.agentToken = agentToken;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    public void setAddress(@NotNull String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @NotNull
    public String getAgentToken() {
        return this.agentToken;
    }

    public void setAgentToken(@NotNull String agentToken) {
        this.agentToken = agentToken;
    }

    public String getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public void setRemoteEndpoint(String locatorUri) {
        this.remoteEndpoint = locatorUri;
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public long getModifiedTime() {
        return this.mtime;
    }

    public Long getLastAvailabilityReport() {
        return this.lastAvailabilityReport;
    }

    public void setLastAvailabilityReport(Long lastAvailabilityReport) {
        this.lastAvailabilityReport = lastAvailabilityReport;
    }

    public AffinityGroup getAffinityGroup() {
        return this.affinityGroup;
    }

    public void setAffinityGroup(AffinityGroup affinityGroup) {
        this.affinityGroup = affinityGroup;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public int getStatus() {
        return this.status;
    }

    public void clearStatus() {
        this.status = 0;
    }

    public void addStatus(Status newStatus) {
        this.status |= newStatus.mask;
    }

    public List<String> getStatusMessages() {
        return Status.getMessages(this.status);
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Agent)) {
            return false;
        }
        Agent agent = (Agent)obj;
        return this.name.equals(agent.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Agent[id=" + this.id + ",name=" + this.name + ",address=" + this.address + ",port=" + this.port + ",remote-endpoint=" + this.remoteEndpoint + ",last-availability-report=" + this.lastAvailabilityReport + "]";
    }

    public static String generateRandomToken(String seed) {
        long seedHash = Math.abs(seed.hashCode());
        Random r = new Random(new Object().hashCode());
        long rand1 = Math.abs(r.nextLong());
        try {
            Thread.sleep(rand1 % 100L + 30L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long rand2 = r.nextLong();
        return System.currentTimeMillis() + "-" + seedHash + "-" + Math.abs(rand2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RESOURCE_HIERARCHY_UPDATED(1, "This agent's managed resource hierarchy has been updated"),
        BASELINES_CALCULATED(2, "This agent's baselines have been recalculated"),
        ALERT_DEFINITION(4, "Some alert definition with an agent-specific condition category was updated");

        public final int mask;
        public final String message;

        private Status(int mask, String message) {
            this.mask = mask;
            this.message = message;
        }

        public static List<String> getMessages(int mask) {
            ArrayList<String> results = new ArrayList<String>();
            for (Status next : Status.values()) {
                if (next.mask != (next.mask & mask)) continue;
                results.add(next.message);
            }
            return results;
        }
    }
}

