/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.cache.CacheScope;
import org.gatein.pc.api.info.CacheInfo;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.api.invocation.response.RevalidateMarkupResponse;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.jsr168.ContentBuffer;
import org.gatein.pc.portlet.impl.jsr168.api.CacheControlImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletURLImpl;
import org.gatein.pc.portlet.impl.jsr168.api.ResourceURLImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MimeResponseImpl
extends PortletResponseImpl
implements MimeResponse {
    protected int bufferSize;
    protected CacheControlImpl cacheControl;
    private boolean contentTypeSet;
    private ContentBuffer responseContent;
    private boolean canSetContentType;

    public MimeResponseImpl(PortletInvocation invocation, PortletRequestImpl preq) {
        super(invocation, preq);
        ContainerPortletInfo info = preq.container.getInfo();
        this.bufferSize = 0;
        this.contentTypeSet = false;
        this.canSetContentType = true;
        this.responseContent = new ContentBuffer();
    }

    protected abstract ContentResponse createMarkupResponse(ResponseProperties var1, Map<String, Object> var2, String var3, byte[] var4, String var5, CacheControl var6);

    @Override
    public PortletInvocationResponse getResponse() {
        CacheControl cc;
        if (this.cacheControl != null) {
            cc = new CacheControl(this.cacheControl.getExpirationTime(), this.cacheControl.isPublicScope() ? CacheScope.PUBLIC : CacheScope.PRIVATE, this.cacheControl.getETag());
        } else {
            ContainerPortletInfo info = this.preq.container.getInfo();
            CacheInfo cacheInfo = info.getCache();
            cc = new CacheControl(cacheInfo.getExpirationSecs(), CacheScope.PRIVATE, null);
        }
        if (this.cacheControl != null && this.cacheControl.useCachedContent()) {
            return new RevalidateMarkupResponse(cc);
        }
        return this.createMarkupResponse(this.getProperties(false), this.preq.attributes.getAttributeMap(), this.responseContent.getContentType(), this.responseContent.getBytes(), this.responseContent.getChars(), cc);
    }

    public String getContentType() {
        return this.contentTypeSet ? this.responseContent.getContentType() : null;
    }

    public void setContentType(String contentType) {
        if (this.canSetContentType) {
            this.responseContent.setContentType(contentType);
            this.contentTypeSet = true;
        }
    }

    public PrintWriter getWriter() throws IOException {
        this.canSetContentType = false;
        if (this.responseContent.getContentType() == null) {
            this.responseContent.setContentType(this.preq.getResponseContentType());
        }
        return this.responseContent.getWriter();
    }

    public OutputStream getPortletOutputStream() throws IOException {
        this.canSetContentType = false;
        if (this.responseContent.getContentType() == null) {
            this.responseContent.setContentType(this.preq.getResponseContentType());
        }
        return this.responseContent.getOutputStream();
    }

    public PortletURL createRenderURL() {
        return PortletURLImpl.createRenderURL(this.invocation, this.preq);
    }

    public PortletURL createActionURL() {
        return PortletURLImpl.createActionURL(this.invocation, this.preq);
    }

    public String getCharacterEncoding() {
        return this.invocation.getContext().getMarkupInfo().getCharset();
    }

    public Locale getLocale() {
        return this.invocation.getUserContext().getLocale();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        this.responseContent.commit();
    }

    public void resetBuffer() {
        this.responseContent.reset();
    }

    public void reset() {
        this.resetBuffer();
        this.getProperties().clear();
    }

    public boolean isCommitted() {
        return this.responseContent.isCommited();
    }

    public ResourceURL createResourceURL() {
        return ResourceURLImpl.createResourceURL(this.invocation, this.preq);
    }

    private void setCache(String key, String value) {
        if ("portlet.expiration-cache".equals(key)) {
            if (value != null) {
                try {
                    int expirationSecs = Integer.parseInt(value);
                    this.getCacheControl().setExpirationTime(expirationSecs);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if ("portlet.ETag".equals(key)) {
            if (value != null) {
                this.getCacheControl().setETag(value);
            }
        } else if ("portlet.use-cached-content".equals(key) && value != null) {
            this.getCacheControl().setUseCachedContent(true);
        }
    }

    @Override
    public void addProperty(String key, String value) throws IllegalArgumentException {
        if ("portlet.expiration-cache".equals(key) || "portlet.ETag".equals(key) || "portlet.use-cached-content".equals(key)) {
            this.setCache(key, value);
        } else {
            super.addProperty(key, value);
        }
    }

    @Override
    public void setProperty(String key, String value) throws IllegalArgumentException {
        if ("portlet.expiration-cache".equals(key) || "portlet.ETag".equals(key) || "portlet.use-cached-content".equals(key)) {
            this.setCache(key, value);
        } else {
            super.setProperty(key, value);
        }
    }

    public javax.portlet.CacheControl getCacheControl() {
        if (this.cacheControl == null) {
            ContainerPortletInfo info = this.preq.container.getInfo();
            CacheInfo cacheInfo = info.getCache();
            this.cacheControl = new CacheControlImpl(cacheInfo.getExpirationSecs(), CacheScope.PRIVATE);
        }
        return this.cacheControl;
    }
}

