/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.scheduler.AbstractScheduleProviderMBean;
import org.jboss.varia.scheduler.ScheduleManagerMBean;

public abstract class AbstractScheduleProvider
extends ServiceMBeanSupport
implements AbstractScheduleProviderMBean {
    private ObjectName scheduleManagerName = ScheduleManagerMBean.OBJECT_NAME;
    private ScheduleManagerMBean manager;

    public ObjectName getScheduleManagerName() {
        return this.scheduleManagerName;
    }

    public void setScheduleManagerName(ObjectName scheduleManagerName) {
        this.scheduleManagerName = scheduleManagerName;
    }

    public abstract void startProviding() throws Exception;

    public abstract void stopProviding();

    protected int addSchedule(ObjectName pTarget, String pMethodName, String[] pMethodSignature, Date pStart, long pPeriod, int pRepetitions) throws JMException {
        return this.manager.addSchedule(this.serviceName, pTarget, pMethodName, pMethodSignature, pStart, pPeriod, pRepetitions);
    }

    protected void removeSchedule(int pID) throws JMException {
        this.manager.removeSchedule(pID);
    }

    protected void startService() throws Exception {
        this.manager = MBeanServerInvocationHandler.newProxyInstance(this.getServer(), this.scheduleManagerName, ScheduleManagerMBean.class, false);
        this.startScheduleProviderService();
    }

    protected void stopService() throws Exception {
        this.stopScheduleProviderService();
    }

    protected void startScheduleProviderService() throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.manager.registerProvider(this.serviceName.toString());
    }

    protected void stopScheduleProviderService() throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.manager.unregisterProvider(this.serviceName.toString());
    }
}

