/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml.checker.beanchildren.ext;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Named;
import javax.annotation.Resource;
import javax.annotation.Stereotype;
import javax.context.ScopeType;
import javax.decorator.Decorator;
import javax.ejb.EJB;
import javax.inject.BindingType;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import javax.inject.Realizes;
import javax.inject.Specializes;
import javax.interceptor.Interceptor;
import javax.interceptor.InterceptorBindingType;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.xml.ParseXmlHelper;
import org.jboss.webbeans.xml.XmlEnvironment;
import org.jboss.webbeans.xml.checker.beanchildren.impl.BeanChildrenCheckerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanChildrenChecker
extends BeanChildrenCheckerImpl {
    private Set<AnnotatedField<?>> beanFields;
    private List<Method> beanMethods;
    private boolean haveBeanDeploymentTypeDeclaration = false;
    private boolean haveBeanScopeTypeDeclaration = false;
    protected boolean haveBeanInterceptorDeclaration = false;
    protected boolean haveBeanDecoratorDeclaration = false;
    protected List<AnnotatedClass<?>> constructorParameters = new ArrayList();

    protected abstract void checkForInterceptorChild(Element var1);

    protected abstract void checkForDecoratorChild(Element var1);

    protected abstract void checkChildForInterceptorType(Element var1);

    protected abstract void checkChildForDecoratorType(Element var1);

    protected abstract void checkForConstructor(Element var1, AnnotatedClass<?> var2);

    protected abstract void checkRIBean(Element var1, AnnotatedClass<?> var2);

    protected AbstractBeanChildrenChecker(XmlEnvironment environment, Map<String, Set<String>> packagesMap) {
        super(environment, packagesMap);
    }

    @Override
    public void checkChildren(Element beanElement, AnnotatedClass<?> beanClass) {
        this.beanFields = beanClass.getFields();
        this.beanMethods = Arrays.asList(beanClass.getRawType().getDeclaredMethods());
        this.checkForInterceptorChild(beanElement);
        this.checkForDecoratorChild(beanElement);
        this.haveBeanDeploymentTypeDeclaration = false;
        this.haveBeanScopeTypeDeclaration = false;
        this.haveBeanInterceptorDeclaration = ParseXmlHelper.findElementsInEeNamespace(beanElement, "Interceptor").size() > 0;
        this.haveBeanDecoratorDeclaration = ParseXmlHelper.findElementsInEeNamespace(beanElement, "Decorator").size() > 0;
        Iterator beanIterator = beanElement.elementIterator();
        while (beanIterator.hasNext()) {
            Element beanChildElement = (Element)beanIterator.next();
            this.checkBeanChild(beanChildElement, beanClass);
        }
        this.checkForConstructor(beanElement, beanClass);
    }

    private void checkBeanChild(Element beanChildElement, AnnotatedClass<?> beanClass) {
        try {
            boolean isInterface;
            if (beanChildElement.getName().equalsIgnoreCase("Array")) {
                return;
            }
            AnnotatedClass<Object> beanChildClass = ParseXmlHelper.loadElementClass(beanChildElement, Object.class, this.environment, this.packagesMap);
            Class beanChildType = beanChildClass.getRawType();
            boolean isJavaClass = !beanChildType.isEnum() && !beanChildType.isPrimitive() && !beanChildType.isInterface();
            boolean bl = isInterface = beanChildType.isInterface() && !beanChildType.isAnnotation();
            if (beanChildType.isAnnotation()) {
                this.checkAnnotationChild(beanChildElement, beanChildClass, beanClass);
                return;
            }
            if (isJavaClass || isInterface) {
                this.constructorParameters.add(beanChildClass);
                return;
            }
            throw new DefinitionException((Throwable)new DefinitionException(beanChildElement.getName() + " can't be interpreted as a Java class or interface or Java Annotation type"));
        }
        catch (DefinitionException e) {
            if (!(e.getCause() instanceof DefinitionException)) {
                throw new DefinitionException((Throwable)e);
            }
            Element beanElement = beanChildElement.getParent();
            Namespace beanNamespace = beanElement.getNamespace();
            Namespace beanChildNamespace = beanChildElement.getNamespace();
            if (beanChildNamespace.equals((Object)beanNamespace)) {
                this.checkFieldOrMethodChild(beanChildElement, beanClass);
                return;
            }
            throw new DefinitionException("Can't determine type of element <" + beanChildElement.getName() + "> in bean '" + beanElement.getName() + "'");
        }
    }

    private void checkAnnotationChild(Element beanChildElement, AnnotatedClass<?> beanChildClass, AnnotatedClass<?> beanClass) {
        if (beanChildClass.isAnnotationPresent(DeploymentType.class)) {
            if (this.haveBeanDeploymentTypeDeclaration) {
                throw new DefinitionException("Only one deployment type declaration allowed for bean '" + beanChildElement.getParent().getName() + "'");
            }
            this.haveBeanDeploymentTypeDeclaration = true;
            return;
        }
        if (beanChildClass.isAnnotationPresent(ScopeType.class)) {
            if (this.haveBeanScopeTypeDeclaration) {
                throw new DefinitionException("Only one scope type declaration allowed for bean '" + beanChildElement.getParent().getName() + "'");
            }
            this.haveBeanScopeTypeDeclaration = true;
            return;
        }
        if (beanChildClass.isAnnotationPresent(Interceptor.class)) {
            this.checkChildForInterceptorType(beanChildElement);
            return;
        }
        if (beanChildClass.isAnnotationPresent(Decorator.class)) {
            this.checkChildForDecoratorType(beanChildElement);
            return;
        }
        if (beanChildClass.isAnnotationPresent(BindingType.class) || beanChildClass.isAnnotationPresent(InterceptorBindingType.class) || beanChildClass.isAnnotationPresent(Stereotype.class) || beanChildClass.isAnnotationPresent(Named.class) || beanChildClass.isAnnotationPresent(Specializes.class) || beanChildClass.isAnnotationPresent(Realizes.class) || beanChildClass.getRawType().equals(BindingType.class) || beanChildClass.getRawType().equals(InterceptorBindingType.class) || beanChildClass.getRawType().equals(Stereotype.class) || beanChildClass.getRawType().equals(Named.class) || beanChildClass.getRawType().equals(Specializes.class) || beanChildClass.getRawType().equals(Realizes.class) || beanChildClass.isAnnotationPresent(Resource.class) || beanChildClass.isAnnotationPresent(EJB.class) || beanChildClass.isAnnotationPresent(WebServiceRef.class) || beanChildClass.isAnnotationPresent(PersistenceContext.class) || beanChildClass.isAnnotationPresent(PersistenceUnit.class)) {
            return;
        }
        if (beanChildClass.getRawType().equals(Resource.class) || beanChildClass.getRawType().equals(EJB.class) || beanChildClass.getRawType().equals(WebServiceRef.class) || beanChildClass.getRawType().equals(PersistenceContext.class) || beanChildClass.getRawType().equals(PersistenceUnit.class)) {
            this.checkRIBean(beanChildElement.getParent(), beanClass);
            return;
        }
        throw new DefinitionException("Can't determine annotation type of <" + beanChildElement.getName() + "> element in bean '" + beanChildElement.getParent().getName() + "'");
    }

    private void checkFieldOrMethodChild(Element beanChildElement, AnnotatedClass<?> beanClass) {
        boolean isField = false;
        boolean isMethod = false;
        for (AnnotatedField<?> field : this.beanFields) {
            if (!beanChildElement.getName().equalsIgnoreCase(field.getName())) continue;
            if (isField) {
                throw new DefinitionException("Bean class '" + beanClass.getName() + "' does not have exactly one field " + "with the specified name '" + beanChildElement.getName() + "'");
            }
            isField = true;
        }
        for (Method method : this.beanMethods) {
            if (!beanChildElement.getName().equalsIgnoreCase(method.getName())) continue;
            isMethod = true;
        }
        if (isField && isMethod) {
            throw new DefinitionException("The name of the child element <" + beanChildElement.getName() + "> matches the name of both a method and a field of the bean class '" + beanClass.getName() + "'");
        }
        if (isField) {
            this.checkFieldChild(beanChildElement, beanClass);
            return;
        }
        if (isMethod) {
            this.checkMethodChild(beanChildElement, beanClass);
            return;
        }
        throw new DefinitionException("The name of the child element <" + beanChildElement.getName() + "> not matches the name of a method or a field of the bean class '" + beanClass.getName() + "'");
    }

    private void checkFieldChild(Element beanChildElement, AnnotatedClass<?> beanClass) {
        String elementUri;
        String elementPrefix;
        String elementName;
        Element elementParent = beanChildElement.getParent();
        if (ParseXmlHelper.findElements(elementParent, elementName = beanChildElement.getName(), elementPrefix = beanChildElement.getNamespacePrefix(), elementUri = beanChildElement.getNamespaceURI()).size() > 1) {
            throw new DefinitionException("More than one child element of a bean '" + elementParent.getName() + "' declaration represents the same field'" + elementName + "'");
        }
        if (beanChildElement.elements().size() > 1 && beanChildElement.elements().size() != ParseXmlHelper.findElementsInEeNamespace(beanChildElement, "value").size()) {
            throw new DefinitionException("Declaration of a field '" + beanChildElement.getName() + "' has more than one direct child element, " + "and at least one of these elements is something other than a <value> element in the Java EE namespace");
        }
    }

    private void checkMethodChild(Element beanChildElement, AnnotatedClass<?> beanClass) {
    }
}

