/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.group;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.group.AbstractAggregateConfigurationUpdate;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DiscriminatorValue(value="plugin")
@Entity
@NamedQueries(value={@NamedQuery(name="AggregatePluginConfigurationUpdate.findByGroupId", query="SELECT apcu FROM AggregatePluginConfigurationUpdate AS apcu WHERE apcu.group.id = :groupId"), @NamedQuery(name="AggregatePluginConfigurationUpdate.findLatestByGroupId", query="SELECT cgu   FROM AggregatePluginConfigurationUpdate cgu  WHERE cgu.group.id = :groupId    AND cgu.modifiedTime = ( SELECT MAX(cgu2.modifiedTime)                              FROM AggregatePluginConfigurationUpdate cgu2                             WHERE cgu2.group.id = :groupId ) "), @NamedQuery(name="AggregatePluginConfigurationUpdate.deleteById", query="DELETE FROM AggregatePluginConfigurationUpdate AS apcu WHERE apcu.id IN ( :ids ) ")})
public class AggregatePluginConfigurationUpdate
extends AbstractAggregateConfigurationUpdate {
    public static final String QUERY_FIND_BY_GROUP_ID = "AggregatePluginConfigurationUpdate.findByGroupId";
    public static final String QUERY_FIND_LATEST_BY_GROUP_ID = "AggregatePluginConfigurationUpdate.findLatestByGroupId";
    public static final String QUERY_DELETE_BY_ID = "AggregatePluginConfigurationUpdate.deleteById";
    private static final long serialVersionUID = 1L;
    @OneToMany(mappedBy="aggregateConfigurationUpdate", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<PluginConfigurationUpdate> configurationUpdates = new ArrayList<PluginConfigurationUpdate>();

    protected AggregatePluginConfigurationUpdate() {
    }

    public AggregatePluginConfigurationUpdate(ResourceGroup group, String subjectName) {
        super(group, subjectName);
        this.configuration = new Configuration();
    }

    public void setConfigurationUpdates(List<PluginConfigurationUpdate> configurationUpdates) {
        this.configurationUpdates = configurationUpdates;
    }

    public List<PluginConfigurationUpdate> getConfigurationUpdates() {
        return this.configurationUpdates;
    }

    public PluginConfigurationUpdate getPluginConfigurationUpdate(Resource updateTarget) {
        Configuration oldResourcePluginConfiguration = updateTarget.getPluginConfiguration();
        Configuration newResourcePluginConfiguration = this.getMergedConfiguration(oldResourcePluginConfiguration, this.configuration);
        PluginConfigurationUpdate update = new PluginConfigurationUpdate(updateTarget, newResourcePluginConfiguration, this.getSubjectName());
        return update;
    }

    private Configuration getMergedConfiguration(Configuration base, Configuration changes) {
        Configuration results = base.deepCopy(false);
        this.merge(results, changes);
        return results;
    }

    private void merge(AbstractPropertyMap base, AbstractPropertyMap changes) {
        for (Map.Entry<String, Property> changesEntry : changes.getMap().entrySet()) {
            String changesPropertyName = changesEntry.getKey();
            Property changesProperty = changesEntry.getValue();
            if (changesProperty instanceof PropertySimple) {
                PropertySimple changesPropertySimple = (PropertySimple)changesProperty;
                if (changesPropertySimple.getOverride() == null || !changesPropertySimple.getOverride().booleanValue()) continue;
                PropertySimple basePropertySimple = (PropertySimple)base.get(changesPropertyName);
                if (basePropertySimple == null) {
                    basePropertySimple = new PropertySimple(changesPropertyName, changesPropertySimple.getStringValue());
                    base.put(basePropertySimple);
                    continue;
                }
                basePropertySimple.setStringValue(changesPropertySimple.getStringValue());
                continue;
            }
            if (!(changesProperty instanceof PropertyMap)) continue;
            PropertyMap changesPropertyMap = (PropertyMap)changesProperty;
            PropertyMap basePropertyMap = (PropertyMap)base.get(changesPropertyName);
            if (basePropertyMap == null) {
                basePropertyMap = new PropertyMap(changesPropertyName);
                base.put(basePropertyMap);
            }
            this.merge(basePropertyMap, changesPropertyMap);
        }
    }

    @Override
    protected void appendToStringInternals(StringBuilder str) {
        super.appendToStringInternals(str);
    }
}

