/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.Sigar;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.event.transfer.EventReport;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.event.EventPollerRunner;
import org.rhq.core.pc.event.EventSenderRunner;
import org.rhq.core.pc.event.EventUtility;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.event.EventPoller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager
implements ContainerService {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String SENDER_THREAD_POOL_NAME = "EventManager.sender";
    private static final int SENDER_THREAD_POOL_CORE_SIZE = 2;
    private static final String POLLER_THREAD_POOL_NAME = "EventManager.poller";
    private static final int POLLER_THREAD_POOL_CORE_SIZE = 3;
    private static final int POLLER_INITIAL_DELAY_SECS = 0;
    private PluginContainerConfiguration pcConfig;
    private ScheduledThreadPoolExecutor senderThreadPool;
    private EventReport activeReport;
    private ReentrantReadWriteLock reportLock = new ReentrantReadWriteLock(true);
    private ScheduledThreadPoolExecutor pollerThreadPool;
    private Map<PollerKey, Runnable> pollerThreads;
    private Sigar sigar;

    @Override
    public void initialize() {
        this.activeReport = new EventReport(this.pcConfig.getEventReportMaxPerSource(), this.pcConfig.getEventReportMaxTotal());
        EventSenderRunner senderRunner = new EventSenderRunner(this);
        this.senderThreadPool = new ScheduledThreadPoolExecutor(2, new LoggingThreadFactory(SENDER_THREAD_POOL_NAME, true));
        this.senderThreadPool.scheduleAtFixedRate(senderRunner, this.pcConfig.getEventSenderInitialDelay(), this.pcConfig.getEventSenderPeriod(), TimeUnit.SECONDS);
        this.pollerThreadPool = new ScheduledThreadPoolExecutor(3, new LoggingThreadFactory(POLLER_THREAD_POOL_NAME, true));
        this.pollerThreads = new HashMap<PollerKey, Runnable>();
    }

    @Override
    public void shutdown() {
        if (this.senderThreadPool != null) {
            this.senderThreadPool.shutdownNow();
        }
        if (this.pollerThreadPool != null) {
            this.pollerThreadPool.shutdownNow();
        }
        if (this.sigar != null) {
            this.sigar.close();
        }
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration config) {
        this.pcConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishEvents(@NotNull Set<Event> events, @NotNull Resource resource) {
        this.reportLock.readLock().lock();
        try {
            for (Event event : events) {
                EventSource eventSource = this.createEventSource(event, resource);
                this.activeReport.addEvent(event, eventSource);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to add Events for " + resource + " to Event report: " + events), t);
        }
        finally {
            this.reportLock.readLock().unlock();
        }
    }

    Sigar getSigar() {
        if (this.sigar == null) {
            this.sigar = new Sigar();
        }
        return this.sigar;
    }

    void sendEventReport(EventReport report) {
        report.addLimitWarningEvents();
        if (!report.getEvents().isEmpty() && this.pcConfig.getServerServices() != null) {
            try {
                this.pcConfig.getServerServices().getEventServerService().mergeEventReport(report);
            }
            catch (Exception e) {
                this.log.warn((Object)"Failure to report Events to Server.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventReport swapReport() {
        this.reportLock.writeLock().lock();
        try {
            EventReport previousReport = this.activeReport;
            this.activeReport = new EventReport(this.pcConfig.getEventReportMaxPerSource(), this.pcConfig.getEventReportMaxTotal());
            EventReport eventReport = previousReport;
            return eventReport;
        }
        finally {
            this.reportLock.writeLock().unlock();
        }
    }

    void registerEventPoller(EventPoller poller, int pollingInterval, Resource resource, String sourceLocation) {
        EventPollerRunner pollerRunner = new EventPollerRunner(poller, resource, this);
        Runnable pollerFuture = (Runnable)((Object)this.pollerThreadPool.scheduleAtFixedRate(pollerRunner, 0L, pollingInterval, TimeUnit.SECONDS));
        PollerKey pollerKey = new PollerKey(resource.getId(), poller.getEventType(), sourceLocation);
        this.pollerThreads.put(pollerKey, pollerFuture);
    }

    void unregisterEventPoller(Resource resource, String eventType, String sourceLocation) {
        PollerKey pollerKey = new PollerKey(resource.getId(), eventType, sourceLocation);
        if (this.pollerThreads.containsKey(pollerKey)) {
            Runnable pollerThread = this.pollerThreads.get(pollerKey);
            boolean wasRemoved = this.pollerThreadPool.remove(pollerThread);
            if (!wasRemoved) {
                this.log.error((Object)("Failed to remove poller with " + pollerKey + " from thread pool."));
            }
            this.pollerThreads.remove(pollerKey);
        }
    }

    private EventSource createEventSource(Event event, Resource resource) {
        EventDefinition eventDefinition = EventUtility.getEventDefinition(event.getType(), resource.getResourceType());
        if (eventDefinition == null) {
            throw new IllegalArgumentException("Unknown type - no EventDefinition found with name '" + event.getType() + "'.");
        }
        return new EventSource(event.getSourceLocation(), eventDefinition, resource);
    }

    static class PollerKey {
        int resourceId;
        String eventType;
        String sourceLocation;

        PollerKey(int resourceId, String eventType, String sourceLocation) {
            this.resourceId = resourceId;
            this.eventType = eventType;
            this.sourceLocation = sourceLocation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PollerKey that = (PollerKey)obj;
            if (this.resourceId != that.resourceId) {
                return false;
            }
            if (!this.eventType.equals(that.eventType)) {
                return false;
            }
            return !(this.sourceLocation != null ? !this.sourceLocation.equals(that.sourceLocation) : that.sourceLocation != null);
        }

        public int hashCode() {
            int result = this.resourceId;
            result = 31 * result + this.eventType.hashCode();
            result = 31 * result + (this.sourceLocation != null ? this.sourceLocation.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PollerKey[resourceId=" + this.resourceId + ", eventType=" + this.eventType + "]";
        }
    }
}

