/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.standard;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.context.CreationalContext;
import javax.inject.manager.InjectionPoint;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.standard.AbstractStandardBean;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFacadeBean<T>
extends AbstractStandardBean<T> {
    private static final Log log = Logging.getLog(AbstractFacadeBean.class);

    protected AbstractFacadeBean(ManagerImpl manager) {
        super(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T create(CreationalContext<T> creationalContext) {
        try {
            DependentContext.instance().setActive(true);
            InjectionPoint injectionPoint = this.getManager().getInjectionPoint();
            if (injectionPoint != null) {
                Type genericType = injectionPoint.getType();
                if (genericType instanceof ParameterizedType) {
                    Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                    T t = this.newInstance(type, this.fixBindings(injectionPoint.getBindings()));
                    return t;
                }
                throw new IllegalStateException("Must have concrete type argument " + injectionPoint);
            }
            log.warn((Object)("Dynamic lookup of " + ((Object)((Object)this)).toString() + " is not supported"), new Object[0]);
            T t = null;
            return t;
        }
        finally {
            DependentContext.instance().setActive(false);
        }
    }

    protected Set<Annotation> fixBindings(Set<? extends Annotation> bindings) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        for (Annotation annotation : bindings) {
            if (this.getFilteredAnnotationTypes().contains(annotation.annotationType())) continue;
            result.add(annotation);
        }
        return result;
    }

    public void destroy(T instance) {
    }

    protected abstract Set<Class<? extends Annotation>> getFilteredAnnotationTypes();

    protected abstract T newInstance(Type var1, Set<Annotation> var2);
}

