/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.spi.ConsumerGroupSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerGroupImpl
implements ConsumerGroupSPI {
    private String key;
    private String name;
    private Map<String, Consumer> consumers;
    private RegistrationStatus status;

    private ConsumerGroupImpl() {
        this.init();
    }

    ConsumerGroupImpl(String name) {
        this.name = name;
        this.init();
    }

    private void init() {
        this.consumers = new HashMap<String, Consumer>();
        this.status = RegistrationStatus.PENDING;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPersistentKey() {
        return this.key;
    }

    @Override
    public void setPersistentKey(String id) {
        this.key = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupImpl that = (ConsumerGroupImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public RegistrationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(RegistrationStatus status) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)status, (String)"RegistrationStatus");
        this.status = status;
    }

    @Override
    public Collection<Consumer> getConsumers() throws RegistrationException {
        return Collections.unmodifiableCollection(this.consumers.values());
    }

    @Override
    public Consumer getConsumer(String consumerId) throws IllegalArgumentException, RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer name", null);
        return this.consumers.get(consumerId);
    }

    @Override
    public boolean isEmpty() {
        return this.consumers.isEmpty();
    }

    @Override
    public void addConsumer(Consumer consumer) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        String identity = consumer.getId();
        if (this.consumers.containsKey(identity)) {
            throw new IllegalArgumentException("ConsumerGroup named '" + this.name + "' already contains a Consumer named '" + consumer.getName() + "' (identity: '" + identity + "')");
        }
        this.consumers.put(identity, consumer);
        consumer.setGroup(this);
    }

    @Override
    public void removeConsumer(Consumer consumer) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        if (this.consumers.remove(consumer.getId()) == null) {
            throw new NoSuchRegistrationException("ConsumerGroup named '" + this.name + "' does not contain a Consumer named '" + consumer.getName() + "' (identity: '" + consumer.getId() + "')");
        }
        consumer.setGroup(null);
    }

    @Override
    public boolean contains(Consumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        return this.consumers.containsKey(consumer.getId());
    }
}

