/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.Name;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.types.TableMetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.api.values.TableValue;
import org.jboss.metatype.api.values.TableValueSupport;
import org.jboss.metatype.plugins.types.StringName;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.system.server.profileservice.persistence.ManagedObjectPersistencePlugin;
import org.jboss.system.server.profileservice.persistence.xml.NullValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedArrayValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCollectionValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCompositeValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedEnumValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedPair;
import org.jboss.system.server.profileservice.persistence.xml.PersistedPropertiesValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedSimpleValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedTableValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

public class AbstractValueRecreation {
    private static final Map<String, Class<? extends Serializable>> simpleTypes = new HashMap<String, Class<? extends Serializable>>();
    private static final Logger log = Logger.getLogger(AbstractValueRecreation.class);
    private final ManagedObjectPersistencePlugin plugin;

    public AbstractValueRecreation(ManagedObjectPersistencePlugin callback) {
        if (callback == null) {
            throw new IllegalArgumentException("null managed object persistence callback");
        }
        this.plugin = callback;
    }

    public ManagedObjectPersistencePlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaValue createMetaValue(PersistedValue valueElement, MetaType metaType) {
        SimpleValue metaValue;
        block13: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing value " + valueElement + " type: " + metaType));
            }
            if (valueElement instanceof NullValue) {
                return null;
            }
            if (valueElement == null) {
                return null;
            }
            metaValue = null;
            if (metaType.isSimple()) {
                metaValue = this.createSimpleValue((PersistedSimpleValue)valueElement, (SimpleMetaType)metaType);
                break block13;
            }
            if (metaType.isEnum()) {
                metaValue = this.createEnumValue((PersistedEnumValue)valueElement, (EnumMetaType)metaType);
                break block13;
            }
            if (metaType.isCollection()) {
                metaValue = this.createCollectionValue((PersistedCollectionValue)valueElement, (CollectionMetaType)metaType);
                break block13;
            }
            if (metaType.isGeneric()) {
                metaValue = this.createGenericValue((PersistedGenericValue)valueElement, (GenericMetaType)metaType);
                break block13;
            }
            if (metaType.isComposite()) {
                metaValue = this.createCompositeValue((PersistedCompositeValue)valueElement, (CompositeMetaType)metaType);
                break block13;
            }
            if (metaType.isTable()) {
                metaValue = this.createTableValue((PersistedTableValue)valueElement, (TableMetaType)metaType);
                break block13;
            }
            if (metaType.isArray()) {
                metaValue = this.createArrayValue((PersistedArrayValue)valueElement, (ArrayMetaType)metaType);
                break block13;
            }
            if (metaType.isProperties()) {
                metaValue = this.createPropertiesValue((PersistedPropertiesValue)valueElement, (PropertiesMetaType)metaType);
                break block13;
            }
            throw new IllegalStateException("unknown metaType");
        }
        return metaValue;
    }

    protected SimpleValue createSimpleValue(PersistedSimpleValue valueElement, SimpleMetaType metaType) {
        String elementValue = valueElement.getValue();
        Object converted = null;
        if (elementValue != null) {
            if (metaType.equals((Object)SimpleMetaType.STRING)) {
                converted = elementValue;
            } else if (metaType.equals((Object)SimpleMetaType.NAMEDOBJECT)) {
                converted = new StringName(elementValue);
            } else if (!metaType.equals((Object)SimpleMetaType.VOID)) {
                converted = this.convert2Type(metaType.getTypeName(), elementValue);
            }
        }
        return new SimpleValueSupport(metaType, converted);
    }

    protected EnumValue createEnumValue(PersistedEnumValue enumElement, EnumMetaType type) {
        return new EnumValueSupport(type, enumElement.getValue());
    }

    protected CompositeValue createCompositeValue(PersistedCompositeValue composite, CompositeMetaType type) {
        if (type instanceof MapCompositeMetaType) {
            return this.handleMapCompositeMetaType(composite, (MapCompositeMetaType)type);
        }
        HashMap<String, MetaValue> values = new HashMap<String, MetaValue>();
        if (composite.getValues() != null && !composite.getValues().isEmpty()) {
            for (PersistedValue persistedValue : composite.getValues()) {
                MetaType elementType = type.getType(persistedValue.getName());
                if (elementType == null) {
                    throw new IllegalStateException("Failed to process composite value: " + persistedValue.getName());
                }
                MetaValue metaValue = this.createMetaValue(persistedValue, elementType);
                values.put(persistedValue.getName(), metaValue);
            }
        }
        return new CompositeValueSupport(type, values);
    }

    protected MapCompositeValueSupport handleMapCompositeMetaType(PersistedCompositeValue composite, MapCompositeMetaType type) {
        HashMap<String, MetaValue> values = new HashMap<String, MetaValue>();
        if (composite.getValues() != null && !composite.getValues().isEmpty()) {
            for (PersistedValue persistedValue : composite.getValues()) {
                MetaValue value = this.createMetaValue(persistedValue, type.getValueType());
                values.put(persistedValue.getName(), value);
            }
        }
        return new MapCompositeValueSupport(values, (MetaType)type);
    }

    protected CollectionValue createCollectionValue(PersistedCollectionValue collection, CollectionMetaType type) {
        ArrayList<MetaValue> elementList = new ArrayList<MetaValue>();
        if (collection.getValues() != null && !collection.getValues().isEmpty()) {
            for (PersistedValue element : collection.getValues()) {
                elementList.add(this.createMetaValue(element, type.getElementType()));
            }
        }
        return new CollectionValueSupport(type, elementList.toArray(new MetaValue[elementList.size()]));
    }

    protected GenericValue createGenericValue(PersistedGenericValue genericElement, GenericMetaType metaType) {
        ManagedObject value = null;
        if (genericElement.getManagedObject() != null) {
            value = this.getPlugin().createManagedObject(genericElement.getManagedObject());
        }
        return new GenericValueSupport(metaType, value);
    }

    protected TableValue createTableValue(PersistedTableValue table, TableMetaType type) {
        TableValueSupport support = new TableValueSupport(type);
        if (table.getEntries() != null && !table.getEntries().isEmpty()) {
            for (PersistedCompositeValue entry : table.getEntries()) {
                support.put(this.createCompositeValue(entry, type.getRowType()));
            }
        }
        return support;
    }

    protected MetaValue createPropertiesValue(PersistedPropertiesValue value, PropertiesMetaType metaType) {
        PropertiesMetaValue properties = new PropertiesMetaValue();
        for (PersistedPair pair : value.getEntries()) {
            properties.setProperty(pair.getKey(), pair.getValue());
        }
        return properties;
    }

    protected ArrayValue createArrayValue(PersistedArrayValue valueElement, ArrayMetaType type) {
        int size = valueElement.size();
        ArrayList<Object> values = new ArrayList<Object>(size);
        for (PersistedValue elementValue : valueElement.getValues()) {
            if (elementValue instanceof PersistedArrayValue) {
                values.add(this.recreateArrayValue((PersistedArrayValue)elementValue, type.getElementType()));
                continue;
            }
            MetaValue value = this.createMetaValue(elementValue, type.getElementType());
            values.add(value);
        }
        return new ArrayValueSupport(type, (Object)values.toArray());
    }

    protected Object recreateArrayValue(PersistedArrayValue valueElement, MetaType type) {
        ArrayList<Object> values = new ArrayList<Object>(valueElement.size());
        for (PersistedValue elementValue : valueElement.getValues()) {
            if (elementValue instanceof PersistedArrayValue) {
                values.add(this.recreateArrayValue((PersistedArrayValue)elementValue, type));
                continue;
            }
            MetaValue value = this.createMetaValue(elementValue, type);
            values.add(value);
        }
        return values.toArray();
    }

    public Serializable convert2Type(String className, String value) {
        if (value == null) {
            return null;
        }
        Class<? extends Serializable> clazz = simpleTypes.get(className);
        if (clazz == null) {
            throw new IllegalStateException("Cannot find simple type entry for " + value + " and class " + className);
        }
        try {
            return (Serializable)ValueConvertor.convertValue(clazz, (Object)value);
        }
        catch (Throwable t) {
            log.debug((Object)("could convert " + value + " to " + clazz.getName()));
            return null;
        }
    }

    static {
        simpleTypes.put(BigDecimal.class.getName(), BigDecimal.class);
        simpleTypes.put(BigInteger.class.getName(), BigInteger.class);
        simpleTypes.put(Boolean.class.getName(), Boolean.class);
        simpleTypes.put(Byte.class.getName(), Byte.class);
        simpleTypes.put(Character.class.getName(), Character.class);
        simpleTypes.put(Date.class.getName(), Date.class);
        simpleTypes.put(Double.class.getName(), Double.class);
        simpleTypes.put(Float.class.getName(), Float.class);
        simpleTypes.put(Integer.class.getName(), Integer.class);
        simpleTypes.put(Long.class.getName(), Long.class);
        simpleTypes.put(Short.class.getName(), Short.class);
        simpleTypes.put(String.class.getName(), String.class);
        simpleTypes.put(Name.class.getName(), Name.class);
        simpleTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        simpleTypes.put(Character.TYPE.getName(), Character.TYPE);
        simpleTypes.put(Double.TYPE.getName(), Double.TYPE);
        simpleTypes.put(Float.TYPE.getName(), Float.TYPE);
        simpleTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        simpleTypes.put(Short.TYPE.getName(), Short.TYPE);
        simpleTypes.put(Long.TYPE.getName(), Long.TYPE);
        simpleTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
    }
}

