/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    public static final String COMA = ",".intern();
    public static final String ST_VIEW_TYPE = "viewType".intern();
    public static final String ST_TIME_INTEVAL = "timeInterval".intern();
    public static final String ST_WEEK_START = "weekStartOn".intern();
    public static final String ST_DATE_FORMAT = "dateFormat".intern();
    public static final String ST_TIME_FORMAT = "timeFormat".intern();
    public static final String ST_LOCALE = "localeId".intern();
    public static final String ST_TIMEZONE = "timezoneId".intern();
    public static final String ST_BASE_URL = "baseUrlForRss".intern();
    public static final String ST_WORKINGTIME = "isShowWorkingTime".intern();
    public static final String ST_TIME_BEGIN = "workingTimeBegin".intern();
    public static final String ST_TIME_END = "workingTimeEnd".intern();
    public static final String ST_USER_IGNORE = "ignoredUsers".intern();
    private CalendarService cservice_;
    private List<String> ignore_users_;
    private CalendarSetting defaultCalendarSetting_;
    public static final String DEFAULT_CALENDAR_CATEGORYID = "defaultCalendarCategoryId";
    public static final String DEFAULT_CALENDAR_ID = "defaultCalendarId";
    public static final String DEFAULT_CALENDAR_CATEGORYNAME = "defaultCalendarCategoryName";
    public static final String DEFAULT_CALENDAR_NAME = "defaultCalendarName";
    public static final String DEFAULT_EVENTCATEGORY_ID_ALL = "defaultEventCategoryIdAll";
    public static final String DEFAULT_EVENTCATEGORY_ID_MEETING = "defaultEventCategoryIdMeeting";
    public static final String DEFAULT_EVENTCATEGORY_ID_CALLS = "defaultEventCategoryIdCalls";
    public static final String DEFAULT_EVENTCATEGORY_ID_CLIENTS = "defaultEventCategoryIdClients";
    public static final String DEFAULT_EVENTCATEGORY_ID_HOLIDAY = "defaultEventCategoryIdHoliday";
    public static final String DEFAULT_EVENTCATEGORY_ID_ANNIVERSARY = "defaultEventCategoryIdAnniversary";
    public static String[] defaultEventCategoryId = new String[]{"defaultEventCategoryIdAll", "defaultEventCategoryIdMeeting", "defaultEventCategoryIdCalls", "defaultEventCategoryIdClients", "defaultEventCategoryIdHoliday", "defaultEventCategoryIdAnniversary"};
    public static final String DEFAULT_EVENTCATEGORY_NAME_ALL = "defaultEventCategoryNameAll";
    public static final String DEFAULT_EVENTCATEGORY_NAME_MEETING = "defaultEventCategoryNameMeeting";
    public static final String DEFAULT_EVENTCATEGORY_NAME_CALLS = "defaultEventCategoryNameCalls";
    public static final String DEFAULT_EVENTCATEGORY_NAME_CLIENTS = "defaultEventCategoryNameClients";
    public static final String DEFAULT_EVENTCATEGORY_NAME_HOLIDAY = "defaultEventCategoryNameHoliday";
    public static final String DEFAULT_EVENTCATEGORY_NAME_ANNIVERSARY = "defaultEventCategoryNameAnniversary";
    public static String[] defaultEventCategoryName = new String[]{"defaultEventCategoryNameAll", "defaultEventCategoryNameMeeting", "defaultEventCategoryNameCalls", "defaultEventCategoryNameClients", "defaultEventCategoryNameHoliday", "defaultEventCategoryNameAnniversary"};

    public NewUserListener() {
    }

    public NewUserListener(CalendarService cservice, InitParams params) throws Exception {
        ValuesParam ignoredUsers;
        this.cservice_ = cservice;
        this.defaultCalendarSetting_ = new CalendarSetting();
        if (params.getValueParam(ST_VIEW_TYPE) != null) {
            this.defaultCalendarSetting_.setViewType(params.getValueParam(ST_VIEW_TYPE).getValue());
        }
        if (params.getValueParam(ST_TIME_INTEVAL) != null) {
            this.defaultCalendarSetting_.setTimeInterval(Long.parseLong(params.getValueParam(ST_TIME_INTEVAL).getValue()));
        }
        if (params.getValueParam(ST_WEEK_START) != null) {
            this.defaultCalendarSetting_.setWeekStartOn(params.getValueParam(ST_WEEK_START).getValue());
        }
        if (params.getValueParam(ST_DATE_FORMAT) != null) {
            this.defaultCalendarSetting_.setDateFormat(params.getValueParam(ST_DATE_FORMAT).getValue());
        }
        if (params.getValueParam(ST_TIME_FORMAT) != null) {
            this.defaultCalendarSetting_.setTimeFormat(params.getValueParam(ST_TIME_FORMAT).getValue());
        }
        if (params.getValueParam(ST_LOCALE) != null) {
            this.defaultCalendarSetting_.setLocation(params.getValueParam(ST_LOCALE).getValue());
        }
        if (params.getValueParam(ST_TIMEZONE) != null) {
            this.defaultCalendarSetting_.setTimeZone(params.getValueParam(ST_TIMEZONE).getValue());
        }
        if (params.getValueParam(ST_BASE_URL) != null) {
            this.defaultCalendarSetting_.setBaseURL(params.getValueParam(ST_BASE_URL).getValue());
        }
        if (params.getValueParam(ST_WORKINGTIME) != null) {
            this.defaultCalendarSetting_.setShowWorkingTime(Boolean.parseBoolean(params.getValueParam(ST_WORKINGTIME).getValue()));
            if (this.defaultCalendarSetting_.isShowWorkingTime()) {
                if (params.getValueParam(ST_TIME_BEGIN) != null) {
                    this.defaultCalendarSetting_.setWorkingTimeBegin(params.getValueParam(ST_TIME_BEGIN).getValue());
                }
                if (params.getValueParam(ST_TIME_END) != null) {
                    this.defaultCalendarSetting_.setWorkingTimeEnd(params.getValueParam(ST_TIME_END).getValue());
                }
            }
        }
        if ((ignoredUsers = params.getValuesParam(ST_USER_IGNORE)) != null && !ignoredUsers.getValues().isEmpty()) {
            this.ignore_users_ = ignoredUsers.getValues();
        }
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        if (this.ignore_users_ != null && !this.ignore_users_.isEmpty()) {
            for (String u : this.ignore_users_) {
                if (!user.getUserName().equalsIgnoreCase(u)) continue;
                return;
            }
        }
        try {
            EventCategory eventCategory = new EventCategory();
            eventCategory.setDataInit(true);
            for (int id = 0; id < defaultEventCategoryId.length; ++id) {
                eventCategory.setId(defaultEventCategoryId[id]);
                eventCategory.setName(defaultEventCategoryName[id]);
                this.cservice_.saveEventCategory(user.getUserName(), eventCategory, true);
            }
            CalendarCategory calCategory = new CalendarCategory();
            calCategory.setId(DEFAULT_CALENDAR_CATEGORYID);
            calCategory.setName(DEFAULT_CALENDAR_CATEGORYNAME);
            calCategory.setDataInit(true);
            this.cservice_.saveCalendarCategory(user.getUserName(), calCategory, true);
            Calendar cal = new Calendar();
            cal.setId(Utils.getDefaultCalendarId(user.getUserName()));
            cal.setName(DEFAULT_CALENDAR_NAME);
            cal.setCategoryId(calCategory.getId());
            cal.setDataInit(true);
            cal.setCalendarOwner(user.getUserName());
            if (this.defaultCalendarSetting_ != null) {
                if (this.defaultCalendarSetting_.getLocation() != null) {
                    cal.setLocale(this.defaultCalendarSetting_.getLocation());
                }
                if (this.defaultCalendarSetting_.getTimeZone() != null) {
                    cal.setTimeZone(this.defaultCalendarSetting_.getTimeZone());
                }
            }
            this.cservice_.saveUserCalendar(user.getUserName(), cal, true);
            if (this.defaultCalendarSetting_ != null && user != null) {
                this.cservice_.saveCalendarSetting(user.getUserName(), this.defaultCalendarSetting_);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

