/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.wsqa.httpclient.FileParameter;
import org.exoplatform.wsqa.httpclient.HttpRequestBody;
import org.exoplatform.wsqa.httpclient.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPostFormRequestBody
extends HttpRequestBody {
    public static final String X_WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    public static final String MULTIPART_FORM_DATA_TYPE = "multipart/form-data";
    public static final String OTHER_TYPE = "other";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private Map<String, Parameter> parameters_;

    public HttpPostFormRequestBody(String contentType, Map<String, Parameter> parameters) throws Exception {
        super(contentType);
        this.parameters_ = parameters;
    }

    public HttpPostFormRequestBody(String contentType, int contentLength, InputStream is) throws Exception {
        super(contentType, contentLength, is);
        if (this.contentType_.startsWith(X_WWW_FORM_URLENCODED_TYPE)) {
            this.parseURLEncodedBody(this.originalData_);
        } else if (this.contentType_.startsWith(MULTIPART_FORM_DATA_TYPE)) {
            this.parseMultipartFormDataBody(this.originalData_);
        }
    }

    @Override
    public byte[] toBytes() {
        StringBuilder b = new StringBuilder();
        if (this.contentType_.startsWith(X_WWW_FORM_URLENCODED_TYPE)) {
            int counter = 0;
            for (Parameter param : this.parameters_.values()) {
                b.append(param.name).append("=").append(param.value);
                if (++counter == this.parameters_.size()) continue;
                b.append("&");
            }
        } else if (this.contentType_.startsWith(MULTIPART_FORM_DATA_TYPE)) {
            String boundary = this.contentType_.split("boundary=")[1];
            int counter = 0;
            for (Parameter param : this.parameters_.values()) {
                b.append(boundary).append("\n");
                if (param instanceof FileParameter) {
                    FileParameter fparam = (FileParameter)param;
                    b.append("Content-Disposition: form-data; ").append("name=\"").append(param.name).append("\" filename=\"").append(fparam.filename).append("\"\n");
                    b.append("Content-Type: ").append(fparam.filetype).append("\n\n");
                    b.append(param.value).append("\n");
                } else {
                    b.append("Content-Disposition: form-data; ").append("name=\"").append(param.name).append("\"\n\n");
                    b.append(param.value);
                }
                b.appendCodePoint(13).appendCodePoint(10);
                ++counter;
            }
            b.append(boundary).append("--");
        }
        return b.toString().getBytes();
    }

    public void parseURLEncodedBody(byte[] body) throws Exception {
        String[] params;
        this.parameters_ = new LinkedHashMap<String, Parameter>();
        String bodyText = new String(body);
        for (String param : params = bodyText.split("&")) {
            String[] pair = param.split("=", 2);
            Parameter parameter = new Parameter(pair[0], pair[1]);
            this.parameters_.put(parameter.name, parameter);
        }
    }

    @Override
    public Map<String, Parameter> getBodyParameters() {
        return this.parameters_;
    }

    private void parseMultipartFormDataBody(byte[] body) throws Exception {
        this.parameters_ = new LinkedHashMap<String, Parameter>();
        ByteArrayOutputStream region = new ByteArrayOutputStream();
        for (int i = 0; i < body.length; ++i) {
            if (body[i] == 13) {
                if (i + 3 >= body.length || body[i + 1] != 10 || body[i + 2] != 45 || body[i + 3] != 45) continue;
                System.out.println("code i - 1 : " + body[i - 1]);
                System.out.println("code i - 2 : " + body[i - 2]);
                ++i;
                Parameter parameter = this.parseFormData(region.toByteArray());
                this.parameters_.put(parameter.name, parameter);
                region.reset();
                continue;
            }
            region.write(body[i]);
        }
    }

    private Parameter parseFormData(byte[] data) throws Exception {
        int firstLineCR = this.findCRPosition(data, 0);
        int contentDispositionCR = this.findCRPosition(data, firstLineCR + 1);
        String contentDiposition = new String(data, firstLineCR + 1, contentDispositionCR - firstLineCR + 1);
        String name = this.getAttributeValue("name", contentDiposition);
        String filename = this.getAttributeValue("filename", contentDiposition);
        String contentType = null;
        int startContentCR = contentDispositionCR + 2;
        if (filename != null) {
            int contentTypeCR = this.findCRPosition(data, contentDispositionCR + 1);
            contentType = new String(data, contentDispositionCR + 1, contentTypeCR - (contentDispositionCR + 1));
            contentType = contentType.split(": ")[1];
            startContentCR = contentTypeCR + 2;
        }
        String content = new String(data, startContentCR, data.length - startContentCR);
        if (filename != null) {
            return new FileParameter(name, filename, contentType, content.trim());
        }
        return new Parameter(name, content);
    }

    private int findCRPosition(byte[] data, int start) {
        for (int i = start; i < data.length; ++i) {
            if (data[i] != 10) continue;
            return i;
        }
        return -1;
    }

    private String getAttributeValue(String name, String text) {
        int start = text.indexOf(name);
        if (start > 0) {
            int limit = text.indexOf("\"", start += name.length() + 2);
            return text.substring(start, limit);
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        return b.toString();
    }

    public static boolean isFormRequest(String contentType) {
        if (contentType.startsWith(X_WWW_FORM_URLENCODED_TYPE)) {
            return true;
        }
        return contentType.startsWith(MULTIPART_FORM_DATA_TYPE);
    }

    public static boolean isUrlEncodedType(String contentType) {
        return contentType.startsWith(X_WWW_FORM_URLENCODED_TYPE);
    }

    public static boolean isMultipartData(String contentType) {
        return contentType.startsWith(MULTIPART_FORM_DATA_TYPE);
    }
}

