/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.ws.frameworks.json.JsonGenerator;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.exoplatform.ws.frameworks.json.value.impl.ArrayValue;
import org.exoplatform.ws.frameworks.json.value.impl.BooleanValue;
import org.exoplatform.ws.frameworks.json.value.impl.DoubleValue;
import org.exoplatform.ws.frameworks.json.value.impl.LongValue;
import org.exoplatform.ws.frameworks.json.value.impl.NullValue;
import org.exoplatform.ws.frameworks.json.value.impl.ObjectValue;
import org.exoplatform.ws.frameworks.json.value.impl.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonGeneratorImpl
implements JsonGenerator {
    @Override
    public JsonValue createJsonObject(Object object) throws JsonException {
        Method[] methods = object.getClass().getMethods();
        List<String> transientFields = JsonGeneratorImpl.getTransientFields(object.getClass());
        ObjectValue jsonRootValue = new ObjectValue();
        for (Method method : methods) {
            String name = method.getName();
            String key = null;
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0 && !"getClass".equals(name)) {
                key = name.substring(3);
            } else if (name.startsWith("is") && name.length() > 2 && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE) && method.getParameterTypes().length == 0) {
                key = name.substring(2);
            }
            if (key == null) continue;
            String string = key = key.length() > 1 ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : key.toLowerCase();
            if (transientFields.contains(key)) continue;
            try {
                Object invokeResult = method.invoke(object, new Object[0]);
                if (JsonUtils.getType(invokeResult) != null) {
                    ((JsonValue)jsonRootValue).addElement(key, this.createJsonValue(invokeResult));
                    continue;
                }
                ((JsonValue)jsonRootValue).addElement(key, this.createJsonObject(invokeResult));
            }
            catch (InvocationTargetException e) {
                throw new JsonException(e);
            }
            catch (IllegalAccessException e) {
                throw new JsonException(e);
            }
        }
        return jsonRootValue;
    }

    protected JsonValue createJsonValue(Object object) throws JsonException {
        JsonUtils.Types t = JsonUtils.getType(object);
        switch (t) {
            case NULL: {
                return new NullValue();
            }
            case BOOLEAN: {
                return new BooleanValue((Boolean)object);
            }
            case BYTE: {
                return new LongValue(((Byte)object).byteValue());
            }
            case SHORT: {
                return new LongValue(((Short)object).shortValue());
            }
            case INT: {
                return new LongValue(((Integer)object).intValue());
            }
            case LONG: {
                return new LongValue((Long)object);
            }
            case FLOAT: {
                return new DoubleValue(((Float)object).floatValue());
            }
            case DOUBLE: {
                return new DoubleValue((Double)object);
            }
            case CHAR: {
                return new StringValue(Character.toString(((Character)object).charValue()));
            }
            case STRING: {
                return new StringValue((String)object);
            }
            case ARRAY_BOOLEAN: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new BooleanValue(Array.getBoolean(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_BYTE: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getByte(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_SHORT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getShort(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_INT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getInt(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_LONG: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getLong(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_FLOAT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new DoubleValue(Array.getFloat(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_DOUBLE: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new DoubleValue(Array.getDouble(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_CHAR: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new StringValue(Character.toString(Array.getChar(object, i))));
                }
                return jsonArray;
            }
            case ARRAY_STRING: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new StringValue((String)Array.get(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_OBJECT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    Object el = Array.get(object, i);
                    if (JsonUtils.getType(el) != null) {
                        ((JsonValue)jsonArray).addElement(this.createJsonValue(el));
                        continue;
                    }
                    ((JsonValue)jsonArray).addElement(this.createJsonObject(el));
                }
                return jsonArray;
            }
            case COLLECTION: {
                ArrayValue jsonArray = new ArrayValue();
                ArrayList list = new ArrayList((Collection)object);
                for (Object o : list) {
                    if (JsonUtils.getType(o) != null) {
                        ((JsonValue)jsonArray).addElement(this.createJsonValue(o));
                        continue;
                    }
                    ((JsonValue)jsonArray).addElement(this.createJsonObject(o));
                }
                return jsonArray;
            }
            case MAP: {
                ObjectValue jsonObject = new ObjectValue();
                HashMap map = new HashMap((Map)object);
                Set keys = map.keySet();
                for (String k : keys) {
                    Object o = map.get(k);
                    if (JsonUtils.getType(o) != null) {
                        ((JsonValue)jsonObject).addElement(k, this.createJsonValue(o));
                        continue;
                    }
                    ((JsonValue)jsonObject).addElement(k, this.createJsonObject(o));
                }
                return jsonObject;
            }
        }
        return null;
    }

    private static List<String> getTransientFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<String> l = new ArrayList<String>();
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (!Modifier.isTransient(f.getModifiers())) continue;
            l.add(f.getName());
        }
        return l;
    }
}

