/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.parser;

import java.io.File;
import java.io.InputStream;
import org.exoplatform.services.chars.CharsDecoder;
import org.exoplatform.services.common.DataReader;
import org.exoplatform.services.common.ServiceConfig;
import org.exoplatform.services.common.ServicesContainer;
import org.exoplatform.services.token.TypeToken;
import org.exoplatform.services.xml.parser.DOMParser;
import org.exoplatform.services.xml.parser.Services;
import org.exoplatform.services.xml.parser.XMLDocument;
import org.exoplatform.services.xml.parser.XMLNode;
import org.exoplatform.services.xml.parser.XMLToken;

public class XMLParser {
    private static final String READER_ID = "XMLParserReader";

    public static synchronized XMLDocument createDocument(char[] data) throws Exception {
        XMLNode root = new XMLNode("document".toCharArray(), "document", TypeToken.TAG);
        XMLDocument document = new XMLDocument(root);
        XMLToken tokens = new XMLToken();
        document.setXmlType(tokens.getXmlType());
        Services.TOKEN_PARSER.getRef().createBeans(tokens, data);
        DOMParser.parse(tokens, root);
        return document;
    }

    public static synchronized XMLDocument createDocument(String text) throws Exception {
        return XMLParser.createDocument(text.toCharArray());
    }

    public static synchronized XMLDocument createDocument(byte[] data, String charset) throws Exception {
        char[] chars = CharsDecoder.decode(charset, data, 0, data.length);
        return XMLParser.createDocument(chars);
    }

    public static synchronized XMLDocument createDocument(InputStream input, String charset) throws Exception {
        DataReader reader = ServicesContainer.get(ServiceConfig.ServiceType.SOFT_REFERENCE, READER_ID, DataReader.class);
        return XMLParser.createDocument(reader.loadInputStream(input).toByteArray(), charset);
    }

    public static synchronized XMLDocument createDocument(File file, String charset) throws Exception {
        DataReader reader = ServicesContainer.get(ServiceConfig.ServiceType.SOFT_REFERENCE, READER_ID, DataReader.class);
        return XMLParser.createDocument(reader.load(file), charset);
    }
}

