/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import org.exoplatform.mail.service.StatusInfo;

public class CheckingInfo {
    public static final int START_CHECKMAIL_STATUS = 101;
    public static final int NO_UPDATE_STATUS = 201;
    public static final int DOWNLOADING_MAIL_STATUS = 150;
    public static final int FINISHED_CHECKMAIL_STATUS = 200;
    public static final int REQUEST_STOP_STATUS = 202;
    public static final int EXECUTING_FILTER = 203;
    public static final int CONNECTION_FAILURE = 102;
    public static final int RETRY_PASSWORD = 103;
    public static final int COMMON_ERROR = 104;
    public static final int START_SYNC_FOLDER = 301;
    public static final int FINISH_SYNC_FOLDER = 302;
    public static final int FINISHED_SYNC_FOLDER = 303;
    public static final String START_MSG_KEY = "starting-status".intern();
    public static final String FETCHING_MSG_KEY = "fetching-mail".intern();
    public static final String START_SYNC_FOLDER_MSG_KEY = "start-sync-folder".intern();
    public static final String FINISH_SYNC_FOLDER_MSG_KEY = "finish-sync-folder".intern();
    public static final String FINISH_MSG_KEY = "finish-check-mail".intern();
    public static final String FINISH_BY_INTERUPTED_KEY = "finish-check-mail-by-interrupted".intern();
    public static final String CONNECTION_FAILURE_KEY = "error-connection-fail".intern();
    public static final String RETRY_PASSWORD_KEY = "msg-retry-password".intern();
    public static final String COMMON_ERROR_KEY = "error-common".intern();
    private int totalMsg_ = 0;
    private int fetching_ = 0;
    private int statusCode_;
    private String statusMsg_;
    private String fetchingToFolders_;
    private boolean hasChanged_;
    private boolean isRequestStop_ = false;
    private String requestingForFolder_;
    private String msgId_;
    private int syncFolderStatus_ = 300;
    private StatusInfo status_ = new StatusInfo();

    public int getTotalMsg() {
        return this.totalMsg_;
    }

    public void setTotalMsg(int totalMsg) {
        this.totalMsg_ = totalMsg;
        this.hasChanged_ = true;
    }

    public int getFetching() {
        return this.fetching_;
    }

    public void setFetching(int in) {
        this.fetching_ = in;
        this.hasChanged_ = true;
    }

    public int getSyncFolderStatus() {
        return this.syncFolderStatus_;
    }

    public void setSyncFolderStatus(int syncFolderStatus) {
        this.syncFolderStatus_ = syncFolderStatus;
        this.hasChanged_ = true;
    }

    public String getFetchingToFolders() {
        return this.fetchingToFolders_;
    }

    public void setFetchingToFolders(String fetchingToFolders) {
        this.fetchingToFolders_ = fetchingToFolders;
    }

    public String getStatusMsg() {
        return this.statusMsg_;
    }

    public void setStatusMsg(String statusMsg) {
        if (this.statusMsg_ != null && this.statusMsg_.equals(statusMsg)) {
            return;
        }
        this.statusMsg_ = statusMsg;
        this.status_.setStatusMsg(this.statusMsg_);
        this.hasChanged_ = true;
    }

    public int getStatusCode() {
        return this.statusCode_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusCode(int code) {
        CheckingInfo checkingInfo = this;
        synchronized (checkingInfo) {
            if (this.statusCode_ != code) {
                this.status_.setPreviousStatus(this.statusCode_);
                this.statusCode_ = code;
                this.status_.setStatus(this.statusCode_);
                this.statusMsg_ = this.generateStatusMsgKey();
                this.status_.setStatusMsg(this.statusMsg_);
                this.hasChanged_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignInterruptedStatus() {
        CheckingInfo checkingInfo = this;
        synchronized (checkingInfo) {
            this.status_.setPreviousStatus(this.statusCode_);
            this.statusCode_ = 200;
            this.status_.setStatus(this.statusCode_);
            this.statusMsg_ = FINISH_BY_INTERUPTED_KEY;
            this.status_.setStatusMsg(this.statusMsg_);
            this.hasChanged_ = true;
        }
    }

    private String generateStatusMsgKey() {
        switch (this.statusCode_) {
            case 101: {
                return START_MSG_KEY;
            }
            case 150: {
                return FETCHING_MSG_KEY;
            }
            case 301: {
                return START_SYNC_FOLDER_MSG_KEY;
            }
            case 302: {
                return FINISH_SYNC_FOLDER_MSG_KEY;
            }
            case 200: {
                return FINISH_MSG_KEY;
            }
            case 102: {
                return CONNECTION_FAILURE_KEY;
            }
            case 103: {
                return RETRY_PASSWORD_KEY;
            }
            case 104: {
                return COMMON_ERROR_KEY;
            }
        }
        return "";
    }

    public boolean hasChanged() {
        return this.hasChanged_;
    }

    public void setHasChanged(boolean b) {
        this.hasChanged_ = b;
    }

    public boolean isRequestStop() {
        return this.isRequestStop_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestStop(boolean b) {
        CheckingInfo checkingInfo = this;
        synchronized (checkingInfo) {
            this.isRequestStop_ = b;
        }
        if (this.statusCode_ != 202) {
            this.status_.setPreviousStatus(this.statusCode_);
            this.statusCode_ = 202;
            this.status_.setStatus(this.statusCode_);
            this.hasChanged_ = true;
        }
    }

    public String getMsgId() {
        return this.msgId_;
    }

    public void setMsgId(String msgId) {
        this.msgId_ = msgId;
    }

    public String getRequestingForFolder_() {
        return this.requestingForFolder_;
    }

    public void setRequestingForFolder_(String str) {
        this.requestingForFolder_ = str;
    }

    public StatusInfo getStatus() {
        return this.status_;
    }

    public void setAccountId(String accountId) {
        this.status_.setAccountId(accountId);
    }

    public String getAccountId() {
        return this.status_.getAccountId();
    }
}

