/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf.chunks;

import org.apache.poi.hdgf.chunks.ChunkHeaderV11;
import org.apache.poi.hdgf.chunks.ChunkHeaderV6;
import org.apache.poi.util.LittleEndian;

public abstract class ChunkHeader {
    protected int type;
    protected int id;
    protected int length;
    protected int unknown1;

    public static ChunkHeader createChunkHeader(int documentVersion, byte[] data, int offset) {
        if (documentVersion >= 6) {
            ChunkHeaderV6 ch = documentVersion > 6 ? new ChunkHeaderV11() : new ChunkHeaderV6();
            ch.type = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 0));
            ch.id = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 4));
            ch.unknown1 = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 8));
            ch.length = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 12));
            ch.unknown2 = LittleEndian.getShort((byte[])data, (int)(offset + 16));
            ch.unknown3 = (short)LittleEndian.getUnsignedByte((byte[])data, (int)(offset + 18));
            return ch;
        }
        if (documentVersion == 5) {
            throw new RuntimeException("TODO");
        }
        throw new IllegalArgumentException("Visio files with versions below 5 are not supported, yours was " + documentVersion);
    }

    public abstract int getSizeInBytes();

    public abstract boolean hasTrailer();

    public abstract boolean hasSeparator();

    public int getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public int getUnknown1() {
        return this.unknown1;
    }
}

