/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.marshalling;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.util.Classes;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.introspection.FieldInfo;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.sunday.marshalling.AttributeMarshaller;
import org.jboss.xb.binding.sunday.marshalling.MarshallingContext;
import org.jboss.xb.binding.sunday.marshalling.TermBeforeMarshallingCallback;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
import org.jboss.xb.binding.sunday.xop.XOPObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallerImpl
extends AbstractMarshaller {
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private Object root;
    private boolean supportNil = true;
    private boolean ignoreUnresolvedWildcard;
    private QName rootTypeQName;
    private SchemaBindingResolver schemaResolver;
    private SchemaBinding schema;
    private MarshallingContextImpl ctx = new MarshallingContextImpl();

    public boolean isIgnoreUnresolvedWildcard() {
        return this.ignoreUnresolvedWildcard;
    }

    public void setIgnoreUnresolvedWildcard(boolean ignoreUnresolvedWildcard) {
        this.ignoreUnresolvedWildcard = ignoreUnresolvedWildcard;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public QName getRootTypeQName() {
        return this.rootTypeQName;
    }

    public void setRootTypeQName(QName rootTypeQName) {
        this.rootTypeQName = rootTypeQName;
    }

    public boolean isSupportNil() {
        return this.supportNil;
    }

    public void setSupportNil(boolean supportNil) {
        this.supportNil = supportNil;
    }

    @Override
    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    @Override
    public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        SchemaBinding model = XsdBinder.bind(xsdReader, null, this.schemaResolver);
        this.marshallInternal(root, model, writer);
    }

    @Override
    public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        SchemaBinding model = XsdBinder.bind(xsdURL, this.schemaResolver);
        this.marshallInternal(root, model, writer);
    }

    public void marshal(SchemaBinding model, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        this.marshallInternal(root, model, writer);
    }

    private void marshallInternal(Object root, SchemaBinding schema, Writer writer) throws IOException, SAXException {
        if (schema == null) {
            throw new JBossXBRuntimeException("XSModel is not available!");
        }
        this.schema = schema;
        this.root = root;
        this.content.startDocument();
        if (this.rootTypeQName != null) {
            if (this.rootQNames.isEmpty()) {
                throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
            }
            QName rootQName = (QName)this.rootQNames.get(0);
            TypeBinding type = schema.getType(this.rootTypeQName);
            if (type == null) {
                throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
            }
            if (MarshallerImpl.isArrayWrapper(type)) {
                this.stack.push(root);
                this.marshalComplexType(rootQName, type, true, false);
                this.stack.pop();
            } else {
                ElementBinding element = new ElementBinding(schema, rootQName, type);
                this.ctx.particle = new ParticleBinding(element);
                this.marshalElementOccurence(element, root, false, true);
            }
        } else if (this.rootQNames.isEmpty()) {
            Iterator<ParticleBinding> elements = schema.getElementParticles();
            if (!elements.hasNext()) {
                throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
            }
            while (elements.hasNext()) {
                ParticleBinding element = elements.next();
                this.ctx.particle = element;
                this.marshalElementOccurence((ElementBinding)element.getTerm(), root, true, true);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                ParticleBinding element = schema.getElementParticle(qName);
                if (element == null) {
                    Iterator<ElementBinding> components = schema.getElements();
                    String roots = "";
                    int j = 0;
                    while (components.hasNext()) {
                        ElementBinding xsObject = components.next();
                        if (j > 0) {
                            roots = roots + ", ";
                        }
                        roots = roots + xsObject.getQName();
                        ++j;
                    }
                    throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
                }
                this.ctx.particle = element;
                this.marshalElementOccurence((ElementBinding)element.getTerm(), root, true, true);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
        if (this.log.isTraceEnabled()) {
            StringWriter traceWriter = new StringWriter();
            contentWriter = new ContentWriter(traceWriter, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
            this.content.handleContent(contentWriter);
            this.log.trace((Object)("marshalled:\n" + traceWriter.getBuffer().toString()));
        }
    }

    private boolean marshalElementOccurence(ElementBinding element, Object value, boolean optional, boolean declareNs) {
        TermBeforeMarshallingCallback marshallingHandler;
        QName xsiTypeQName = null;
        TypeBinding xsiType = null;
        if (value != null) {
            QName typeQName = element.getType().getQName();
            xsiTypeQName = (QName)this.cls2TypeMap.get(value.getClass());
            if (!(xsiTypeQName == null || typeQName.getLocalPart().equals(xsiTypeQName.getLocalPart()) && typeQName.getNamespaceURI().equals(xsiTypeQName.getNamespaceURI()))) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(value.getClass() + " is mapped to xsi:type " + xsiTypeQName));
                }
                if ((xsiType = this.schema.getType(xsiTypeQName)) == null) {
                    this.log.warn((Object)("Class " + value.getClass() + " is mapped to type " + xsiTypeQName + " but the type is not found in schema."));
                }
            }
        }
        if ((marshallingHandler = element.getBeforeMarshallingCallback()) != null) {
            value = marshallingHandler.beforeMarshalling(value, this.ctx);
        }
        this.stack.push(value);
        boolean marshalled = this.marshalElement(element, xsiType, optional, declareNs);
        this.stack.pop();
        return marshalled;
    }

    private boolean marshalElement(ElementBinding element, TypeBinding xsiType, boolean optional, boolean declareNs) {
        boolean trace;
        Object value = this.stack.peek();
        boolean nillable = element.isNillable();
        boolean result = value != null || value == null && (optional || nillable);
        boolean bl = trace = this.log.isTraceEnabled() && result;
        if (trace) {
            this.log.trace((Object)("started element " + element.getQName()));
        }
        if (value != null) {
            boolean declareXsiType = xsiType != null;
            this.marshalElementType(element.getQName(), declareXsiType ? xsiType : element.getType(), declareNs, declareXsiType);
        } else if (nillable) {
            this.writeNillable(element.getQName(), nillable);
        }
        if (trace) {
            this.log.trace((Object)("finished element " + element.getQName()));
        }
        return result;
    }

    private void marshalElementType(QName elementQName, TypeBinding type, boolean declareNs, boolean declareXsiType) {
        String elementNs = elementQName.getNamespaceURI();
        String elementLocal = elementQName.getLocalPart();
        XOPMarshaller xopMarshaller = this.schema.getXopMarshaller();
        if (xopMarshaller == null) {
            xopMarshaller = type.getXopMarshaller();
        }
        if (xopMarshaller != null && MarshallerImpl.isXopOptimizable(type)) {
            if (xopMarshaller.isXOPPackage()) {
                boolean genPrefix;
                Object o = this.stack.peek();
                String cid = xopMarshaller.addMtomAttachment(new XOPObject(o), elementNs, elementLocal);
                AttributesImpl attrs = null;
                String prefix = this.getPrefix(elementNs);
                boolean bl = genPrefix = prefix == null && elementNs != null && elementNs.length() > 0;
                if (genPrefix) {
                    prefix = "ns_" + elementLocal;
                    attrs = new AttributesImpl(1);
                    MarshallerImpl.declareNs(attrs, prefix, elementNs);
                }
                String qName = MarshallerImpl.prefixLocalName(prefix, elementLocal);
                this.content.startElement(elementNs, elementLocal, qName, attrs);
                AttributesImpl xopAttrs = new AttributesImpl(2);
                xopAttrs.add("http://www.w3.org/2001/XMLSchema", "xop", "xmlns:xop", "CDATA", "http://www.w3.org/2004/08/xop/include");
                xopAttrs.add(null, "href", "href", "CDATA", cid);
                this.content.startElement("http://www.w3.org/2004/08/xop/include", "Include", "xop:Include", xopAttrs);
                this.content.endElement("http://www.w3.org/2004/08/xop/include", "Include", "xop:Include");
                this.content.endElement(elementNs, elementLocal, qName);
                return;
            }
            if (!type.isSimple() && type.hasOnlyXmlMimeAttributes()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("XML MIME attributes of type " + type.getQName() + " are ignored, the value is marshalled as " + type.getSimpleType().getQName()));
                }
                type = type.getSimpleType();
            }
        }
        if (type.isSimple()) {
            this.marshalSimpleType(elementQName, type, declareNs, declareXsiType);
        } else {
            this.marshalComplexType(elementQName, type, declareNs, declareXsiType);
        }
    }

    private void marshalSimpleType(QName elementQName, TypeBinding type, boolean declareNs, boolean declareXsiType) {
        String typeName;
        boolean genPrefix;
        this.ctx.attrs = null;
        if ((declareNs || declareXsiType) && this.nsRegistry.size() > 0) {
            if (this.ctx.attrs == null) {
                this.ctx.attrs = new AttributesImpl(this.nsRegistry.size() + 1);
            }
            this.declareNs(this.ctx.attrs);
        }
        String elementNs = elementQName.getNamespaceURI();
        String elementLocal = elementQName.getLocalPart();
        String prefix = this.getPrefix(elementNs);
        boolean bl = genPrefix = prefix == null && elementNs != null && elementNs.length() > 0;
        if (genPrefix) {
            prefix = "ns_" + elementLocal;
            if (this.ctx.attrs == null) {
                this.ctx.attrs = new AttributesImpl(1);
            }
            MarshallerImpl.declareNs(this.ctx.attrs, prefix, elementNs);
        }
        if (declareXsiType) {
            this.declareXsiType(type.getQName(), this.ctx.attrs);
        }
        String string = typeName = type.getQName() == null ? null : type.getQName().getLocalPart();
        if (this.ctx.attrs == null && "QName".equals(typeName) || "NOTATION".equals(typeName) || type.getItemType() != null && ("QName".equals(type.getItemType().getQName().getLocalPart()) || "NOTATION".equals(type.getItemType().getQName().getLocalPart()))) {
            this.ctx.attrs = new AttributesImpl(5);
        }
        Object value = this.stack.peek();
        String marshalled = this.marshalCharacters(elementNs, prefix, type, value);
        String qName = MarshallerImpl.prefixLocalName(prefix, elementLocal);
        this.content.startElement(elementNs, elementLocal, qName, this.ctx.attrs);
        this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
        this.content.endElement(elementNs, elementLocal, qName);
    }

    private void marshalComplexType(QName elementQName, TypeBinding type, boolean declareNs, boolean declareXsiType) {
        boolean genPrefix;
        Collection<AttributeBinding> attrBindings = type.getAttributes();
        int attrsTotal = declareNs || declareXsiType ? this.nsRegistry.size() + attrBindings.size() + 1 : attrBindings.size();
        this.ctx.attrs = attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null;
        if (declareNs && this.nsRegistry.size() > 0) {
            this.declareNs(this.ctx.attrs);
        }
        String generatedPrefix = null;
        if (declareXsiType && (generatedPrefix = this.declareXsiType(type.getQName(), this.ctx.attrs)) != null) {
            String typeNsWithGeneratedPrefix = type.getQName().getNamespaceURI();
            MarshallerImpl.declareNs(this.ctx.attrs, generatedPrefix, typeNsWithGeneratedPrefix);
            this.declareNamespace(generatedPrefix, typeNsWithGeneratedPrefix);
        }
        String elementNs = elementQName.getNamespaceURI();
        String elementLocal = elementQName.getLocalPart();
        String prefix = this.getPrefix(elementNs);
        boolean bl = genPrefix = prefix == null && elementNs != null && elementNs.length() > 0;
        if (genPrefix) {
            prefix = "ns_" + elementLocal;
            this.declareNamespace(prefix, elementNs);
            if (this.ctx.attrs == null) {
                this.ctx.attrs = new AttributesImpl(1);
            }
            MarshallerImpl.declareNs(this.ctx.attrs, prefix, elementNs);
        }
        if (!attrBindings.isEmpty()) {
            for (AttributeBinding attrBinding : attrBindings) {
                QName attrQName = attrBinding.getQName();
                if (Constants.QNAME_XMIME_CONTENTTYPE.equals(attrQName)) continue;
                this.ctx.attr = attrBinding;
                AttributeMarshaller marshaller = attrBinding.getMarshaller();
                String marshalledAttr = marshaller.marshal(this.ctx);
                if (marshalledAttr == null) continue;
                if (this.ctx.attrs == null) {
                    this.ctx.attrs = new AttributesImpl(5);
                }
                String attrNs = attrQName.getNamespaceURI();
                String attrLocal = attrQName.getLocalPart();
                String attrPrefix = null;
                if (attrNs != null && (attrPrefix = this.getPrefix(attrNs)) == null && attrNs != null && attrNs.length() > 0) {
                    attrPrefix = "ns_" + attrLocal;
                    MarshallerImpl.declareNs(this.ctx.attrs, attrPrefix, attrNs);
                }
                String prefixedName = MarshallerImpl.prefixLocalName(attrPrefix, attrLocal);
                this.ctx.attrs.add(attrNs, attrLocal, prefixedName, "CDATA", marshalledAttr);
            }
            this.ctx.attr = null;
        }
        String characters = null;
        TypeBinding simpleType = type.getSimpleType();
        if (simpleType != null && !Constants.QNAME_ANYTYPE.equals(type.getQName())) {
            PropertyMetaData propertyMetaData;
            String fieldName = this.ctx.getSimpleContentProperty();
            CharactersMetaData charactersMetaData = type.getCharactersMetaData();
            PropertyMetaData propertyMetaData2 = propertyMetaData = charactersMetaData == null ? null : charactersMetaData.getProperty();
            if (propertyMetaData != null) {
                fieldName = propertyMetaData.getName();
            }
            if (fieldName != null) {
                boolean ignoreUnresolvedFieldOrClass = type.getSchemaBinding().isIgnoreUnresolvedFieldOrClass();
                Object o = this.stack.peek();
                Object value = MarshallerImpl.getElementValue(o, fieldName, ignoreUnresolvedFieldOrClass);
                if (value != null) {
                    String typeName = simpleType.getQName().getLocalPart();
                    if (this.ctx.attrs == null && ("QName".equals(typeName) || "NOTATION".equals(typeName) || simpleType.getItemType() != null && ("QName".equals(simpleType.getItemType().getQName().getLocalPart()) || "NOTATION".equals(simpleType.getItemType().getQName().getLocalPart())))) {
                        this.ctx.attrs = new AttributesImpl(5);
                    }
                    characters = this.marshalCharacters(elementNs, prefix, simpleType, value);
                }
            }
        }
        String qName = MarshallerImpl.prefixLocalName(prefix, elementLocal);
        this.content.startElement(elementNs, elementLocal, qName, this.ctx.attrs);
        ParticleBinding particle = type.getParticle();
        if (particle != null) {
            this.marshalParticle(particle, false);
        }
        if (characters != null) {
            this.content.characters(characters.toCharArray(), 0, characters.length());
        }
        this.content.endElement(elementNs, elementLocal, qName);
        this.ctx.attrs = null;
        if (genPrefix) {
            this.removePrefixMapping(prefix);
        }
        if (generatedPrefix != null) {
            this.removePrefixMapping(generatedPrefix);
        }
    }

    private boolean marshalParticle(ParticleBinding particle, boolean declareNs) {
        boolean marshalled;
        TermBinding term = particle.getTerm();
        ParticleBinding ctxParticle = this.ctx.particle;
        this.ctx.particle = particle;
        if (term.isModelGroup()) {
            ModelGroupBinding modelGroup = (ModelGroupBinding)term;
            if (modelGroup.isSkip() || this.stack.isEmpty()) {
                marshalled = this.marshalModelGroup(modelGroup, declareNs);
            } else {
                Iterator<?> i;
                PropertyMetaData propertyMetaData = modelGroup.getPropertyMetaData();
                if (propertyMetaData == null) {
                    throw new JBossXBRuntimeException("Currently, property binding metadata must be available for a model group to be marshalled!");
                }
                Object o = MarshallerImpl.getChildren(this.stack.peek(), propertyMetaData.getName(), modelGroup.getSchema().isIgnoreUnresolvedFieldOrClass());
                TermBeforeMarshallingCallback marshallingHandler = modelGroup.getBeforeMarshallingCallback();
                Iterator<?> iterator = i = o != null && MarshallerImpl.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        if (marshallingHandler != null) {
                            value = marshallingHandler.beforeMarshalling(value, this.ctx);
                        }
                        this.stack.push(value);
                        marshalled = this.marshalModelGroup(modelGroup, declareNs);
                        this.stack.pop();
                    }
                } else {
                    if (marshallingHandler != null) {
                        o = marshallingHandler.beforeMarshalling(o, this.ctx);
                    }
                    this.stack.push(o);
                    marshalled = this.marshalModelGroup(modelGroup, declareNs);
                    this.stack.pop();
                }
            }
        } else if (term.isWildcard()) {
            Iterator<?> i;
            Object o = this.stack.peek();
            boolean popWildcardValue = false;
            ObjectLocalMarshaller marshaller = null;
            AbstractMarshaller.FieldToWildcardMapping mapping = (AbstractMarshaller.FieldToWildcardMapping)this.field2WildcardMap.get(o.getClass());
            if (mapping != null) {
                marshaller = mapping.marshaller;
                o = mapping.fieldInfo.getValue(o);
                this.stack.push(o);
                popWildcardValue = true;
            }
            TermBeforeMarshallingCallback marshallingHandler = term.getBeforeMarshallingCallback();
            Iterator<?> iterator = i = o != null && MarshallerImpl.isRepeatable(particle) ? this.getIterator(o) : null;
            if (i != null) {
                marshalled = true;
                while (i.hasNext() && marshalled) {
                    Object value = i.next();
                    if (marshallingHandler != null) {
                        value = marshallingHandler.beforeMarshalling(value, this.ctx);
                    }
                    marshalled = this.marshalWildcardOccurence(particle, marshaller, value, declareNs);
                }
            } else {
                if (marshallingHandler != null) {
                    o = marshallingHandler.beforeMarshalling(o, this.ctx);
                }
                marshalled = this.marshalWildcardOccurence(particle, marshaller, o, declareNs);
            }
            if (popWildcardValue) {
                this.stack.pop();
            }
        } else {
            Iterator<?> i;
            ElementBinding element = (ElementBinding)term;
            SchemaBinding schema = element.getSchema();
            Object o = this.getElementValue(element, schema.isIgnoreLowLine(), schema.isIgnoreUnresolvedFieldOrClass());
            Iterator<?> iterator = i = o != null && MarshallerImpl.isRepeatable(particle) ? this.getIterator(o) : null;
            if (i != null) {
                marshalled = true;
                while (i.hasNext() && marshalled) {
                    Object value = i.next();
                    marshalled = this.marshalElementOccurence(element, value, particle.getMinOccurs() == 0, declareNs);
                }
            } else {
                marshalled = this.marshalElementOccurence(element, o, particle.getMinOccurs() == 0, declareNs);
            }
        }
        this.ctx.particle = ctxParticle;
        return marshalled;
    }

    private boolean marshalWildcardOccurence(ParticleBinding particle, ObjectLocalMarshaller marshaller, Object value, boolean declareNs) {
        boolean marshalled = true;
        if (marshaller != null) {
            marshaller.marshal(this.ctx, value);
        } else if (value != null) {
            this.stack.push(value);
            marshalled = this.marshalWildcard(particle, declareNs);
            this.stack.pop();
        }
        return marshalled;
    }

    private boolean marshalWildcard(ParticleBinding particle, boolean declareNs) {
        boolean marshalled;
        WildcardBinding wildcard = (WildcardBinding)particle.getTerm();
        Object o = this.stack.peek();
        AbstractMarshaller.ClassMapping mapping = this.getClassMapping(o.getClass());
        if (mapping == null) {
            QName autoType = SimpleTypeBindings.typeQName(o.getClass());
            if (autoType != null) {
                String marshalled2 = SimpleTypeBindings.marshal(autoType.getLocalPart(), o, null);
                this.content.characters(marshalled2.toCharArray(), 0, marshalled2.length());
                return true;
            }
            ObjectLocalMarshaller marshaller = wildcard.getUnresolvedMarshaller();
            if (marshaller != null) {
                marshaller.marshal(this.ctx, o);
                return true;
            }
            String msg = "Failed to marshal wildcard: neither class mapping was found for " + o.getClass() + "@" + o.hashCode() + " (toString: " + o + ") nor marshaller for unresolved classes was setup.";
            if (this.ignoreUnresolvedWildcard) {
                this.log.warn((Object)msg);
                return true;
            }
            throw new JBossXBRuntimeException(msg);
        }
        Object parentRoot = this.root;
        AbstractMarshaller.Stack parentStack = this.stack;
        SchemaBinding parentSchema = this.schema;
        this.root = o;
        this.stack = new AbstractMarshaller.StackImpl();
        SchemaBinding schemaBinding = this.schema = mapping.schemaUrl == null ? this.schema : XsdBinder.bind(mapping.schemaUrl, this.schemaResolver);
        if (mapping.elementName != null) {
            ParticleBinding element = this.schema.getElementParticle(mapping.elementName);
            if (element == null) {
                throw new JBossXBRuntimeException("Element " + mapping.elementName + " is not declared in the schema.");
            }
            ParticleBinding ctxParticle = this.ctx.particle;
            this.ctx.particle = element;
            marshalled = this.marshalElementOccurence((ElementBinding)element.getTerm(), this.root, particle.getMinOccurs() == 0, declareNs);
            this.ctx.particle = ctxParticle;
        } else if (mapping.typeName != null) {
            TypeBinding typeDef = this.schema.getType(mapping.typeName);
            if (typeDef == null) {
                throw new JBossXBRuntimeException("Type " + mapping.typeName + " is not defined in the schema.");
            }
            if (wildcard.getQName() == null) {
                throw new JBossXBRuntimeException("Expected the wildcard to have a non-null QName.");
            }
            ElementBinding element = new ElementBinding(this.schema, wildcard.getQName(), typeDef);
            ParticleBinding ctxParticle = this.ctx.particle;
            this.ctx.particle = new ParticleBinding(element);
            marshalled = this.marshalElementOccurence(element, this.root, particle.getMinOccurs() == 0, declareNs);
            this.ctx.particle = ctxParticle;
        } else {
            throw new JBossXBRuntimeException("Class mapping for " + mapping.cls + " is associated with neither global element name nor global type name.");
        }
        this.root = parentRoot;
        this.stack = parentStack;
        this.schema = parentSchema;
        return marshalled;
    }

    private boolean marshalModelGroup(ModelGroupBinding modelGroup, boolean declareNs) {
        boolean marshalled = modelGroup instanceof AllBinding ? this.marshalModelGroupAll(modelGroup.getParticles(), declareNs) : (modelGroup instanceof ChoiceBinding ? this.marshalModelGroupChoice(modelGroup.getParticles(), declareNs) : this.marshalModelGroupSequence(modelGroup, declareNs));
        return marshalled;
    }

    private boolean marshalModelGroupAll(Collection<ParticleBinding> particles, boolean declareNs) {
        boolean marshalled = false;
        for (ParticleBinding particle : particles) {
            marshalled |= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private boolean marshalModelGroupChoice(Collection<ParticleBinding> particles, boolean declareNs) {
        boolean marshalled = false;
        Content mainContent = this.content;
        Iterator<ParticleBinding> i = particles.iterator();
        while (i.hasNext() && !marshalled) {
            ParticleBinding particle = i.next();
            this.content = new Content();
            marshalled = this.marshalParticle(particle, declareNs);
        }
        if (marshalled) {
            mainContent.append(this.content);
        }
        this.content = mainContent;
        return marshalled;
    }

    private boolean marshalModelGroupSequence(ModelGroupBinding sequence, boolean declareNs) {
        Object o;
        Iterator<?> valueIterator = null;
        if (!sequence.isSkip() && !this.stack.isEmpty() && (o = this.stack.peek()) != null && (Collection.class.isAssignableFrom(o.getClass()) || o.getClass().isArray())) {
            valueIterator = this.getIterator(o);
        }
        boolean marshalled = true;
        Iterator<ParticleBinding> i = sequence.getParticles().iterator();
        while (i.hasNext()) {
            if (valueIterator != null) {
                Object o2 = valueIterator.hasNext() ? valueIterator.next() : null;
                this.stack.push(o2);
            }
            ParticleBinding particle = i.next();
            marshalled &= this.marshalParticle(particle, declareNs);
            if (valueIterator == null) continue;
            this.stack.pop();
        }
        return marshalled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String marshalCharacters(String elementUri, String elementPrefix, TypeBinding simpleType, Object value) {
        boolean removePrefix;
        String prefix;
        String typeName;
        QName simpleTypeQName = simpleType.getQName();
        if (simpleType.getItemType() != null) {
            List list;
            TypeBinding itemType = simpleType.getItemType();
            if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getQName().getNamespaceURI())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
            if (value instanceof List) {
                list = (List)value;
                return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
            } else {
                if (!value.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
                list = MarshallerImpl.asList(value);
            }
            return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
        }
        if (simpleTypeQName != null && "http://www.w3.org/2001/XMLSchema".equals(simpleTypeQName.getNamespaceURI())) {
            QName qNameValue;
            typeName = simpleTypeQName.getLocalPart();
            prefix = null;
            removePrefix = false;
            if (("QName".equals(typeName) || "NOTATION".equals(typeName)) && (qNameValue = (QName)value).getNamespaceURI() != null && qNameValue.getNamespaceURI().length() > 0 && (prefix = this.nsRegistry.getPrefix(qNameValue.getNamespaceURI())) == null) {
                prefix = qNameValue.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = qNameValue.getLocalPart() + "_ns";
                }
                this.nsRegistry.addPrefixMapping(prefix, qNameValue.getNamespaceURI());
                this.ctx.declareNamespace(prefix, qNameValue.getNamespaceURI());
                removePrefix = true;
            }
        } else {
            Method getValue;
            if (simpleType.getLexicalPattern() != null && simpleType.getBaseType() != null && Constants.QNAME_BOOLEAN.equals(simpleType.getBaseType().getQName())) {
                String item = simpleType.getLexicalPattern().get(0);
                if (item.indexOf(48) != -1 && item.indexOf(49) != -1) {
                    if ((Boolean)value == false) return "0";
                    return "1";
                }
                if ((Boolean)value == false) return "false";
                return "true";
            }
            if (simpleType.getLexicalEnumeration() == null) return this.marshalCharacters(elementUri, elementPrefix, simpleType.getBaseType(), value);
            try {
                getValue = value.getClass().getMethod("value", null);
            }
            catch (NoSuchMethodException e) {
                try {
                    getValue = value.getClass().getMethod("getValue", null);
                }
                catch (NoSuchMethodException e1) {
                    throw new JBossXBRuntimeException("Failed to find neither value() nor getValue() in " + value.getClass() + " which is bound to enumeration type " + simpleTypeQName);
                }
            }
            try {
                value = getValue.invoke(value, null);
                return this.marshalCharacters(elementUri, elementPrefix, simpleType.getBaseType(), value);
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to invoke getValue() on " + value + " to get the enumeration value", e);
            }
        }
        String marshalled = SimpleTypeBindings.marshal(typeName, value, this.nsRegistry);
        if (!removePrefix) return marshalled;
        this.nsRegistry.removePrefixMapping(prefix);
        return marshalled;
    }

    private void writeNillable(QName elementQName, boolean nillable) {
        AttributesImpl attrs;
        if (!this.supportNil) {
            return;
        }
        if (!nillable) {
            throw new JBossXBRuntimeException("Failed to marshal " + elementQName + ": Java value is null but the element is not nillable.");
        }
        String elementNs = elementQName.getNamespaceURI();
        String elementLocal = elementQName.getLocalPart();
        String prefix = this.getPrefix(elementNs);
        if (prefix == null && elementNs != null && elementNs.length() > 0) {
            prefix = "ns_" + elementLocal;
            attrs = new AttributesImpl(2);
            MarshallerImpl.declareNs(attrs, prefix, elementNs);
        } else {
            attrs = new AttributesImpl(1);
        }
        String xsiPrefix = this.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null) {
            xsiPrefix = "xsi";
            MarshallerImpl.declareNs(attrs, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        String nilQName = xsiPrefix + ":nil";
        attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
        String qName = MarshallerImpl.prefixLocalName(prefix, elementLocal);
        this.content.startElement(elementNs, elementLocal, qName, attrs);
        this.content.endElement(elementNs, elementLocal, qName);
    }

    private Object getElementValue(ElementBinding element, boolean ignoreLowLine, boolean ignoreNotFoundField) {
        Object value;
        Object peeked = this.stack.peek();
        if (peeked == null) {
            value = null;
        } else if (peeked instanceof Collection || peeked.getClass().isArray()) {
            value = peeked;
        } else {
            String fieldName = null;
            PropertyMetaData propertyMetaData = element.getPropertyMetaData();
            if (propertyMetaData != null) {
                fieldName = propertyMetaData.getName();
            }
            if (fieldName == null) {
                fieldName = Util.xmlNameToFieldName(element.getQName().getLocalPart(), ignoreLowLine);
            }
            if ((value = MarshallerImpl.getChildren(peeked, fieldName, ignoreNotFoundField)) == null) {
                value = MarshallerImpl.getElementValue(peeked, fieldName, ignoreNotFoundField);
            }
        }
        return value;
    }

    private static boolean isArrayWrapper(TypeBinding type) {
        ParticleBinding particle;
        boolean is = false;
        if (!type.isSimple() && (particle = type.getParticle()) != null) {
            is = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
        }
        return is;
    }

    private Iterator<?> getIterator(Object value) {
        Iterator i = null;
        if (value instanceof Collection) {
            i = ((Collection)value).iterator();
        } else if (value.getClass().isArray()) {
            final Object arr = value;
            i = new Iterator(){
                private int curInd = 0;
                private int length = Array.getLength(arr);

                public boolean hasNext() {
                    return this.curInd < this.length;
                }

                public Object next() {
                    return Array.get(arr, this.curInd++);
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove is not implemented.");
                }
            };
        } else if (value instanceof Iterator) {
            i = (Iterator)value;
        }
        return i;
    }

    private static Object getChildren(Object o, String fieldName, boolean ignoreNotFoundField) {
        Object children = null;
        if (!MarshallerImpl.writeAsValue(o.getClass())) {
            children = MarshallerImpl.getJavaValue(fieldName, o, true, ignoreNotFoundField);
        }
        return children;
    }

    private static Object getJavaValue(String fieldName, Object o, boolean forComplexType, boolean ignoreNotFoundField) {
        FieldInfo fieldInfo = FieldInfo.getFieldInfo(o.getClass(), fieldName, !ignoreNotFoundField);
        Object value = null;
        if (fieldInfo != null && (!forComplexType || forComplexType && !MarshallerImpl.writeAsValue(fieldInfo.getType()))) {
            value = fieldInfo.getValue(o);
        }
        return value;
    }

    private static Object getElementValue(Object o, String fieldName, boolean ignoreNotFoundField) {
        Object value = MarshallerImpl.writeAsValue(o.getClass()) ? o : MarshallerImpl.getJavaValue(fieldName, o, false, ignoreNotFoundField);
        return value;
    }

    private static boolean writeAsValue(Class<?> type) {
        return Classes.isPrimitive(type) || type == String.class || type == Date.class || type == BigDecimal.class || type == BigInteger.class;
    }

    private static boolean isRepeatable(ParticleBinding particle) {
        return particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1 || particle.getMinOccurs() > 1;
    }

    private static final List asList(final Object arr) {
        return new AbstractList(){
            private final Object array;
            {
                this.array = arr;
            }

            public Object get(int index) {
                return Array.get(this.array, index);
            }

            public int size() {
                return Array.getLength(this.array);
            }
        };
    }

    private static boolean isXopOptimizable(TypeBinding type) {
        while (type != null) {
            if (Constants.QNAME_BASE64BINARY.equals(type.getQName())) {
                return true;
            }
            type = type.getBaseType();
        }
        return false;
    }

    private class MarshallingContextImpl
    implements MarshallingContext {
        private ContentHandler ch;
        private AttributeBinding attr;
        private ParticleBinding particle;
        private AttributesImpl attrs;

        private MarshallingContextImpl() {
        }

        public boolean isAttributeRequired() {
            throw new UnsupportedOperationException();
        }

        public boolean isTypeComplex() {
            throw new UnsupportedOperationException();
        }

        public String getSimpleContentProperty() {
            return MarshallerImpl.this.schema.getSimpleContentProperty();
        }

        public ContentHandler getContentHandler() {
            if (this.ch == null) {
                this.ch = new AbstractMarshaller.ContentHandlerAdaptor();
            }
            return this.ch;
        }

        public SchemaBinding getSchemaBinding() {
            return MarshallerImpl.this.schema;
        }

        public AttributeBinding getAttributeBinding() {
            return this.attr;
        }

        public String getPrefix(String ns) {
            return MarshallerImpl.this.getPrefix(ns);
        }

        public void declareNamespace(String prefix, String ns) {
            MarshallerImpl.declareNs(this.attrs, prefix, ns);
            MarshallerImpl.this.nsRegistry.addPrefixMapping(prefix, ns);
        }

        public NamespaceRegistry getNamespaceContext() {
            return MarshallerImpl.this.nsRegistry;
        }

        public Object peek() {
            return MarshallerImpl.this.stack.isEmpty() ? null : MarshallerImpl.this.stack.peek();
        }

        public ParticleBinding getParticleBinding() {
            return this.particle;
        }
    }
}

