/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest;

import java.util.Collection;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.rest.RESTOrganizationService;

public abstract class RESTOrganizationServiceAbstractImpl
implements RESTOrganizationService {
    protected static final Log LOGGER = ExoLogger.getLogger((String)"cs.contact.service");
    protected final GroupHandler groupHandler;
    protected final UserHandler userHandler;
    protected final MembershipHandler membershipHandler;
    protected final MembershipTypeHandler membershipTypeHandler;
    protected final OrganizationService organizationService_;

    protected RESTOrganizationServiceAbstractImpl(OrganizationService organizationService) {
        this.groupHandler = organizationService.getGroupHandler();
        this.userHandler = organizationService.getUserHandler();
        this.membershipHandler = organizationService.getMembershipHandler();
        this.membershipTypeHandler = organizationService.getMembershipTypeHandler();
        this.organizationService_ = organizationService;
    }

    protected void start() {
        PortalContainer manager = PortalContainer.getInstance();
        ((ComponentRequestLifecycle)this.organizationService_).startRequest((ExoContainer)manager);
    }

    protected void stop() {
        PortalContainer manager = PortalContainer.getInstance();
        ((ComponentRequestLifecycle)this.organizationService_).endRequest((ExoContainer)manager);
    }

    public Response createGroup(String baseURI, String groupName, String label, String description, String parentId) {
        Group parent = null;
        Group group = null;
        this.start();
        try {
            if (parentId != null && parentId.length() > 0 && (parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId)) == null) {
                return Response.status((int)404).entity((Object)("Parent group '" + parentId + "' not found!")).build();
            }
            group = this.groupHandler.createGroupInstance();
            group.setGroupName(groupName);
            group.setLabel(label);
            group.setDescription(description);
            this.groupHandler.addChild(parent, group, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return Response.ok((Object)group).build();
    }

    public Response createMembership(String baseURI, String username, String groupId, String type) {
        Membership m = null;
        try {
            this.start();
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.status((int)404).entity((Object)("User : '" + username + "' not found!")).build();
            }
            Group group = this.groupHandler.findGroupById(groupId = groupId.startsWith("/") ? groupId : "/" + groupId);
            if (group == null) {
                return Response.status((int)404).entity((Object)("Group : '" + groupId + "' not found!")).build();
            }
            MembershipType membershipType = this.membershipTypeHandler.findMembershipType(type);
            m = this.membershipHandler.findMembershipByUserGroupAndType(username, groupId, type);
            if (membershipType == null) {
                return Response.status((int)404).entity((Object)("MembershipType : '" + type + "' not found!")).build();
            }
            this.membershipHandler.linkMembership(user, group, membershipType, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return Response.ok((Object)m).build();
    }

    public Response createUser(String baseURI, String username, String password, String firstname, String lastname, String email) {
        try {
            this.start();
            User user = this.userHandler.createUserInstance(username);
            if (user == null) {
                return Response.status((int)404).entity((Object)("User '" + username + "' not found.")).build();
            }
            user.setPassword(password);
            user.setFirstName(firstname);
            user.setLastName(lastname);
            user.setEmail(email);
            this.userHandler.createUser(user, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return null;
    }

    public Response deleteGroup(String groupId) {
        try {
            this.start();
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.status((int)404).entity((Object)("Group '" + groupId + "' not found!")).build();
            }
            this.groupHandler.removeGroup(group, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return null;
    }

    public Response deleteMembership(String membershipId) {
        try {
            this.start();
            this.membershipHandler.removeMembership(membershipId, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return null;
    }

    public Response deleteUser(String username) {
        try {
            this.start();
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.status((int)404).entity((Object)("User '" + username + "' not found.")).build();
            }
            this.userHandler.removeUser(username, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return null;
    }

    public Response deleteUserFromGroup(String baseURI, String groupId, String username) {
        try {
            this.start();
            String string = groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            if (this.userHandler.findUserByName(username) == null || this.groupHandler.findGroupById(groupId) == null) {
                return Response.status((int)404).entity((Object)"Group or user not found!").build();
            }
            Collection memberships = this.membershipHandler.findMembershipsByUserAndGroup(username, groupId);
            for (Membership m : memberships) {
                this.membershipHandler.removeMembership(m.getId(), true);
            }
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return null;
    }

    public Response updateGroup(String baseURI, String groupId, String name, String label, String description) {
        try {
            this.start();
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.status((int)404).entity((Object)("Group '" + groupId + "' not found!")).build();
            }
            group.setGroupName(name);
            group.setLabel(label);
            group.setDescription(description);
            this.groupHandler.saveGroup(group, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return null;
    }

    public Response updateUser(String baseURI, String username, String password, String firstname, String lastname, String email) {
        try {
            this.start();
            User user = this.userHandler.findUserByName(username);
            user.setPassword(password);
            user.setFirstName(firstname);
            user.setLastName(lastname);
            user.setEmail(email);
            this.userHandler.saveUser(user, true);
            this.stop();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot manage user : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
        return null;
    }

    public Response findMembership(String baseURI, String membershipId) {
        return null;
    }

    public Response findMemberships(String baseURI, String groupId, String username, String type) {
        return null;
    }

    public Response findUsers(String baseURI, String username, String firstname, String lastname, String email, String fromLoginDate, String toLoginDate) {
        return null;
    }

    public Response findUsersRange(String baseURI, String username, String firstname, String lastname, String email, String fromLoginDate, String toLoginDate, Integer offset, Integer amount) {
        return null;
    }

    public Response getAllGroup(String baseURI, String filter) {
        return null;
    }

    public Response getGroup(String baseURI, String groupId) {
        return null;
    }

    public Response getGroups(String baseURI, String parentId) {
        return null;
    }

    public Response getGroupsCount() {
        return null;
    }

    public Response getGroupsOfUser(String baseURI, String username) {
        return null;
    }

    public Response getGroupsRange(String baseURI, Integer offset, Integer amount, String parentId) {
        return null;
    }

    public Response getMembershipTypes() {
        return null;
    }

    public Response getUser(String username) {
        return null;
    }

    public Response getUsers(String baseURI) {
        return null;
    }

    public Response getUsersCount() {
        return null;
    }

    public Response getUsersRange(String baseURI, Integer offset, Integer amount) {
        return null;
    }
}

