/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class ByteArrayPersistedValueData
extends AbstractPersistedValueData
implements Externalizable {
    private static final long serialVersionUID = -9131328056670315388L;
    protected byte[] data;

    public ByteArrayPersistedValueData() {
        super(0);
    }

    public ByteArrayPersistedValueData(int orderNumber, byte[] data) {
        super(orderNumber);
        this.data = data;
    }

    public InputStream getAsStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public byte[] getAsByteArray() {
        return this.data;
    }

    public long getLength() {
        return this.data.length;
    }

    public long read(OutputStream stream, long length, long position) throws IOException {
        if (position < 0L) {
            throw new IOException("Position must be higher or equals 0. But given " + position);
        }
        if (length < 0L) {
            throw new IOException("Length must be higher or equals 0. But given " + length);
        }
        if (position >= (long)this.data.length && position > 0L) {
            throw new IOException("Position " + position + " out of value size " + this.data.length);
        }
        if (position + length >= (long)this.data.length) {
            length = (long)this.data.length - position;
        }
        stream.write(this.data, (int)position, (int)length);
        return length;
    }

    public boolean isByteArray() {
        return true;
    }

    public boolean equals(ValueData another) {
        if (this == another) {
            return true;
        }
        if (this.isByteArray() && another.isByteArray()) {
            try {
                return Arrays.equals(this.getAsByteArray(), another.getAsByteArray());
            }
            catch (IOException e) {
                LOG.error((Object)"Read error", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        return new TransientValueData(this.orderNumber, this.data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        this.data = new byte[in.readInt()];
        in.readFully(this.data);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        out.writeInt(this.data.length);
        out.write(this.data);
    }
}

