/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.mail.service.CsObjectParam;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailUpdateStorageEventListener;
import org.exoplatform.services.jcr.RepositoryService;

public class MailUpdateStorage
extends MailUpdateStorageEventListener {
    private MailService service_;
    private RepositoryService repositorySerivce_;
    CsObjectParam csObj_;

    public MailUpdateStorage(MailService service, InitParams params, RepositoryService repositorySerivce) throws Exception {
        this.service_ = service;
        this.repositorySerivce_ = repositorySerivce;
        this.csObj_ = (CsObjectParam)params.getObjectParam("cs.mail.update.object").getObject();
    }

    public void preUpdate() {
    }

    private void setValue(int propertyType, boolean isMultiple, NodeIterator it, String proName, String value) throws Exception {
        while (it.hasNext()) {
            Node node = it.nextNode();
            ValueFactory vf = node.getSession().getValueFactory();
            switch (propertyType) {
                case 1: {
                    if (isMultiple) {
                        node.setProperty(proName, value.split(","));
                        break;
                    }
                    node.setProperty(proName, value);
                    break;
                }
                case 6: {
                    Value[] values;
                    String[] strings;
                    if (isMultiple) {
                        strings = value.split(",");
                        values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            values[i] = vf.createValue(Boolean.parseBoolean(strings[i]));
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    node.setProperty(proName, Boolean.parseBoolean(value));
                    break;
                }
                case 3: {
                    Value[] values;
                    String[] strings;
                    if (isMultiple) {
                        strings = value.split(",");
                        values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            values[i] = vf.createValue(Long.parseLong(strings[i]));
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    node.setProperty(proName, Long.parseLong(value));
                    break;
                }
                case 4: {
                    Value[] values;
                    String[] strings;
                    if (isMultiple) {
                        strings = value.split(",");
                        values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            values[i] = vf.createValue(Double.parseDouble(strings[i]));
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    node.setProperty(proName, Double.parseDouble(value));
                    break;
                }
                case 5: {
                    SimpleDateFormat df = new SimpleDateFormat();
                    Calendar cal = Calendar.getInstance();
                    if (isMultiple) {
                        String[] strings = value.split(",");
                        Value[] values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            cal.setTime(df.parse(value));
                            values[i] = vf.createValue(cal);
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    cal.setTime(df.parse(value));
                    node.setProperty(proName, cal);
                    break;
                }
            }
            node.save();
        }
    }

    private void setValue(int propertyType, NodeIterator it, String proName, Value[] vls) throws Exception {
        while (it.hasNext()) {
            Node node = it.nextNode();
            node.setProperty(proName, vls);
            node.save();
        }
    }

    private void updateValue(int propertyType, boolean isMultiple, NodeIterator it, String addPropertyName, String removeName) throws Exception {
        while (it.hasNext()) {
            Node node = it.nextNode();
            switch (propertyType) {
                case 1: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getString());
                    break;
                }
                case 6: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getBoolean());
                    break;
                }
                case 3: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getLong());
                    break;
                }
                case 4: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getDouble());
                    break;
                }
                case 5: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getDate());
                    break;
                }
            }
            node.getProperty(removeName).remove();
            node.save();
        }
    }

    public void postUpdate() {
        super.postUpdate();
    }
}

