/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.alternatives.ImmutablePicoContainer;
import org.picocontainer.defaults.AbstractPicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.LifecycleVisitor;
import org.picocontainer.defaults.VerifyingVisitor;

public class ConcurrentPicoContainer
implements MutablePicoContainer,
Serializable {
    private static final long serialVersionUID = -2275793454555604533L;
    private final ConcurrentMap<Object, ComponentAdapter> componentKeyToAdapterCache = new ConcurrentHashMap<Object, ComponentAdapter>();
    private final ComponentAdapterFactory componentAdapterFactory;
    private final PicoContainer parent;
    private final Set<ComponentAdapter> componentAdapters = new CopyOnWriteArraySet<ComponentAdapter>();
    private final CopyOnWriteArrayList<ComponentAdapter> orderedComponentAdapters = new CopyOnWriteArrayList();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final Set<PicoContainer> children = new CopyOnWriteArraySet<PicoContainer>();

    public ConcurrentPicoContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        if (componentAdapterFactory == null) {
            throw new NullPointerException("componentAdapterFactory");
        }
        this.componentAdapterFactory = componentAdapterFactory;
        this.parent = parent == null ? null : new ImmutablePicoContainer(parent);
    }

    public ConcurrentPicoContainer(PicoContainer parent) {
        this((ComponentAdapterFactory)new DefaultComponentAdapterFactory(), parent);
    }

    public ConcurrentPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    public ConcurrentPicoContainer() {
        this((ComponentAdapterFactory)new DefaultComponentAdapterFactory(), null);
    }

    public Collection getComponentAdapters() {
        return Collections.unmodifiableSet(this.componentAdapters);
    }

    public final ComponentAdapter getComponentAdapter(Object componentKey) throws AmbiguousComponentResolutionException {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            ComponentAdapter componentAdapter = (ComponentAdapter)found.get(i);
            foundClasses[i] = componentAdapter.getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.componentAdapters) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        return found;
    }

    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.putIfAbsent(componentKey, componentAdapter) != null) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        this.componentAdapters.add(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        this.orderedComponentAdapters.remove(adapter);
        return adapter;
    }

    public ComponentAdapter registerComponentInstance(Object component) throws PicoRegistrationException {
        return this.registerComponentInstance(component.getClass(), component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        if (componentInstance instanceof MutablePicoContainer) {
            MutablePicoContainer pc = (MutablePicoContainer)componentInstance;
            Object contrivedKey = new Object();
            String contrivedComp = "";
            pc.registerComponentInstance(contrivedKey, (Object)contrivedComp);
            try {
                if (this.getComponentInstance(contrivedKey) != null) {
                    throw new PicoRegistrationException("Cannot register a container to itself. The container is already implicitly registered.");
                }
            }
            finally {
                pc.unregisterComponent(contrivedKey);
            }
        }
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance);
        this.registerComponent((ComponentAdapter)componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentKey, componentImplementation, (Parameter[])null);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoRegistrationException {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, List parameters) throws PicoRegistrationException {
        Parameter[] parametersAsArray = parameters.toArray(new Parameter[parameters.size()]);
        return this.registerComponentImplementation(componentKey, componentImplementation, parametersAsArray);
    }

    private void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        this.orderedComponentAdapters.addIfAbsent(componentAdapter);
    }

    public List getComponentInstances() throws PicoException {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List getComponentInstancesOfType(Class componentType) throws PicoException {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<ComponentAdapter, Object> adapterToInstanceMap = new HashMap<ComponentAdapter, Object>();
        for (ComponentAdapter componentAdapter : this.componentAdapters) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            Object componentInstance = this.getInstance(componentAdapter);
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            this.addOrderedComponentAdapter(componentAdapter);
        }
        ArrayList result = new ArrayList();
        for (ComponentAdapter componentAdapter : this.orderedComponentAdapters) {
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentInstance);
        }
        return result;
    }

    public Object getComponentInstance(Object componentKey) throws PicoException {
        ComponentAdapter componentAdapter = this.getComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return this.getInstance(componentAdapter);
        }
        return null;
    }

    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    private Object getInstance(ComponentAdapter componentAdapter) {
        boolean isLocal = this.componentAdapters.contains(componentAdapter);
        if (isLocal) {
            Object instance = componentAdapter.getComponentInstance((PicoContainer)this);
            this.addOrderedComponentAdapter(componentAdapter);
            return instance;
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        for (ComponentAdapter componentAdapter : this.componentAdapters) {
            if (!this.getInstance(componentAdapter).equals(componentInstance)) continue;
            return this.unregisterComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse((Object)this);
    }

    public void start() {
        if (this.disposed.get() || this.started.get()) {
            return;
        }
        LifecycleVisitor.start((Object)this);
        this.started.set(true);
    }

    public void stop() {
        if (this.disposed.get() || !this.started.get()) {
            return;
        }
        LifecycleVisitor.stop((Object)this);
        this.started.set(false);
    }

    public void dispose() {
        if (this.disposed.get()) {
            return;
        }
        LifecycleVisitor.dispose((Object)this);
        this.disposed.set(true);
    }

    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer(this.componentAdapterFactory, (PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        return pc;
    }

    public boolean addChildContainer(PicoContainer child) {
        return this.children.add(child);
    }

    public boolean removeChildContainer(PicoContainer child) {
        return this.children.remove(child);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        for (ComponentAdapter componentAdapter : this.componentAdapters) {
            componentAdapter.accept(visitor);
        }
        for (PicoContainer child : this.children) {
            child.accept(visitor);
        }
    }

    protected void accept(ContainerVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        for (PicoContainer child : this.children) {
            child.accept((PicoVisitor)visitor);
        }
    }

    protected static abstract class ContainerVisitor
    extends AbstractPicoVisitor {
        protected ContainerVisitor() {
        }

        public final void visitComponentAdapter(ComponentAdapter componentAdapter) {
        }

        public final void visitParameter(Parameter parameter) {
        }
    }
}

