/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.helper;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    public static <E> List<E> toList(Enumeration<E> e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> list = new ArrayList<E>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block4: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block4;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block4;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static String stripDnToName(String dn) {
        if (dn == null || dn.length() == 0) {
            throw new IllegalArgumentException("Cannot process empty dn");
        }
        Object name = null;
        String[] parts = dn.split(",");
        if ((parts = parts[0].split("=")).length != 2) {
            throw new IllegalArgumentException("Wrong dn format: " + dn);
        }
        return parts[1];
    }

    public static String getOptionSingleValue(String optionName, Map<String, List<String>> options) {
        if (options == null || options.size() == 0) {
            return null;
        }
        List<String> values = options.get(optionName);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

