/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.ArrayList;
import java.util.List;
import org.reflext.api.TypeInfo;
import org.reflext.api.WildcardTypeInfo;
import org.reflext.core.TypeDomain;
import org.reflext.core.TypeInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WildcardTypeInfoImpl<T, M>
extends TypeInfoImpl<T, M>
implements WildcardTypeInfo {
    private final T wildcardType;
    private List<TypeInfo> upperBounds;
    private List<TypeInfo> lowerBounds;

    public WildcardTypeInfoImpl(TypeDomain<T, M> domain, T wildcardType) {
        super(domain);
        this.wildcardType = wildcardType;
    }

    public T getType() {
        return this.wildcardType;
    }

    public List<TypeInfo> getUpperBounds() {
        if (this.upperBounds == null) {
            ArrayList<TypeInfo> upperBounds = new ArrayList<TypeInfo>();
            for (Object upperBound : this.domain.typeModel.getUpperBounds(this.wildcardType)) {
                upperBounds.add(this.domain.getType(upperBound));
            }
            this.upperBounds = upperBounds;
        }
        return this.upperBounds;
    }

    public List<TypeInfo> getLowerBounds() {
        if (this.lowerBounds == null) {
            ArrayList<TypeInfo> lowerBounds = new ArrayList<TypeInfo>();
            for (Object lowerBound : this.domain.typeModel.getLowerBounds(this.wildcardType)) {
                lowerBounds.add(this.domain.getType(lowerBound));
            }
            this.lowerBounds = lowerBounds;
        }
        return this.lowerBounds;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getUpperBounds()).hashCode() ^ ((Object)this.getLowerBounds()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WildcardTypeInfo) {
            WildcardTypeInfo that = (WildcardTypeInfo)obj;
            return ((Object)this.getUpperBounds()).equals(that.getUpperBounds()) && ((Object)this.getLowerBounds()).equals(that.getLowerBounds());
        }
        return false;
    }
}

