/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core.nodetype;

import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;

public class ItemDefinitionData {
    protected final InternalQName name;
    protected final InternalQName declaringNodeType;
    protected final boolean autoCreated;
    protected final boolean mandatory;
    protected final int onParentVersion;
    protected final boolean protectedItem;

    public ItemDefinitionData(InternalQName name, InternalQName declaringNodeType, boolean autoCreated, boolean mandatory, int onParentVersion, boolean protectedItem) {
        this.name = name;
        this.declaringNodeType = declaringNodeType;
        this.autoCreated = autoCreated;
        this.mandatory = mandatory;
        this.onParentVersion = onParentVersion;
        this.protectedItem = protectedItem;
    }

    public boolean isResidualSet() {
        return this.getName().equals((Object)Constants.JCR_ANY_NAME);
    }

    public InternalQName getName() {
        return this.name;
    }

    public InternalQName getDeclaringNodeType() {
        return this.declaringNodeType;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoCreated ? 1231 : 1237);
        result = 31 * result + (this.declaringNodeType == null ? 0 : this.declaringNodeType.hashCode());
        result = 31 * result + (this.mandatory ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.onParentVersion;
        result = 31 * result + (this.protectedItem ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemDefinitionData)) {
            return false;
        }
        ItemDefinitionData other = (ItemDefinitionData)obj;
        if (this.autoCreated != other.autoCreated) {
            return false;
        }
        if (this.declaringNodeType == null ? other.declaringNodeType != null : !this.declaringNodeType.equals((Object)other.declaringNodeType)) {
            return false;
        }
        if (this.mandatory != other.mandatory) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        if (this.onParentVersion != other.onParentVersion) {
            return false;
        }
        return this.protectedItem == other.protectedItem;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    public boolean isProtected() {
        return this.protectedItem;
    }

    public String toString() {
        return this.name.getAsString();
    }
}

