/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.OnWorkspaceInconsistency;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.DefaultIndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryHandler
implements QueryHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.AbstractQueryHandler");
    private QueryHandlerContext context;
    protected boolean initialized = false;
    private OnWorkspaceInconsistency owi = OnWorkspaceInconsistency.FAIL;
    private String queryClass = QueryImpl.class.getName();
    private String idleTime;
    protected IndexerIoModeHandler modeHandler;
    protected IndexInfos indexInfos;
    private IndexUpdateMonitor indexUpdateMonitor;

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setIndexerIoModeHandler(IndexerIoModeHandler modeHandler) throws IOException {
        this.modeHandler = modeHandler;
    }

    @Override
    public void setContext(QueryHandlerContext context) {
        this.context = context;
    }

    @Override
    public void init() throws IOException, RepositoryException, RepositoryConfigurationException {
        this.doInit();
        this.initialized = true;
    }

    protected abstract void doInit() throws IOException, RepositoryException;

    @Override
    public QueryHandlerContext getContext() {
        return this.context;
    }

    @Override
    public void updateNodes(Iterator<String> remove, Iterator<NodeData> add) throws RepositoryException, IOException {
        while (remove.hasNext()) {
            this.deleteNode(remove.next());
        }
        while (add.hasNext()) {
            this.addNode(add.next());
        }
    }

    public OnWorkspaceInconsistency getOnWorkspaceInconsistencyHandler() {
        return this.owi;
    }

    public void setOnWorkspaceInconsistency(String name) {
        this.owi = OnWorkspaceInconsistency.fromString(name);
    }

    public String getOnWorkspaceInconsistency() {
        return this.owi.getName();
    }

    public void setQueryClass(String queryClass) {
        this.queryClass = queryClass;
    }

    @Override
    public String getQueryClass() {
        return this.queryClass;
    }

    public void setIdleTime(String idleTime) {
        log.warn("Parameter 'idleTime' is not supported anymore. Please use 'maxIdleTime' in the repository configuration.");
        this.idleTime = idleTime;
    }

    public String getIdleTime() {
        return this.idleTime;
    }

    @Override
    public void setIndexInfos(IndexInfos indexInfos) {
        this.indexInfos = indexInfos;
    }

    @Override
    public IndexInfos getIndexInfos() {
        return this.indexInfos == null ? new IndexInfos() : this.indexInfos;
    }

    @Override
    public IndexUpdateMonitor getIndexUpdateMonitor() {
        return this.indexUpdateMonitor == null ? new DefaultIndexUpdateMonitor() : this.indexUpdateMonitor;
    }

    @Override
    public void setIndexUpdateMonitor(IndexUpdateMonitor indexUpdateMonitor) {
        this.indexUpdateMonitor = indexUpdateMonitor;
    }
}

