/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesSynonymProvider
implements SynonymProvider {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.PropertiesSynonymProvider");
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final long CHECK_INTERVAL = 10000L;
    private InputStream config;
    private long lastCheck;
    private long configLastModified;
    private Map synonyms = new HashMap();

    public synchronized void initialize(InputStream fsr) throws IOException {
        if (fsr == null) {
            throw new IOException("PropertiesSynonymProvider requires a path configuration");
        }
        try {
            this.config = fsr;
            this.synonyms = PropertiesSynonymProvider.getSynonyms(this.config);
            this.configLastModified = System.currentTimeMillis();
            this.lastCheck = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw Util.createIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSynonyms(String term) {
        String[] syns;
        this.checkConfigUpdated();
        term = term.toLowerCase();
        PropertiesSynonymProvider propertiesSynonymProvider = this;
        synchronized (propertiesSynonymProvider) {
            syns = (String[])this.synonyms.get(term);
        }
        if (syns == null) {
            syns = EMPTY_ARRAY;
        }
        return syns;
    }

    private synchronized void checkConfigUpdated() {
        if (this.lastCheck + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastCheck = System.currentTimeMillis();
    }

    private static Map getSynonyms(InputStream config) throws IOException {
        try {
            HashMap synonyms = new HashMap();
            Properties props = new Properties();
            props.load(config);
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                PropertiesSynonymProvider.addSynonym(key, value, synonyms);
                PropertiesSynonymProvider.addSynonym(value, key, synonyms);
            }
            return synonyms;
        }
        catch (Exception e) {
            throw Util.createIOException(e);
        }
    }

    private static void addSynonym(String term, String synonym, Map synonyms) {
        String[] syns = (String[])synonyms.get(term = term.toLowerCase());
        if (syns == null) {
            syns = new String[]{synonym};
        } else {
            String[] tmp = new String[syns.length + 1];
            System.arraycopy(syns, 0, tmp, 0, syns.length);
            tmp[syns.length] = synonym;
            syns = tmp;
        }
        synonyms.put(term, syns);
    }
}

