/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Client;
import dojox.cometd.Extension;
import dojox.cometd.Listener;
import dojox.cometd.Message;
import dojox.cometd.MessageListener;
import dojox.cometd.RemoveListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
implements Client {
    private String _id;
    private String _type;
    private Object _messageQ = null;
    private int _responsesPending;
    private ChannelImpl[] _subscriptions = new ChannelImpl[0];
    private boolean _JSONCommented;
    private Listener _listener;
    private List<RemoveListener> _rListeners;
    private List<MessageListener> _mListeners;
    protected AbstractBayeux _bayeux;
    private String _browserId;
    private int _adviseVersion;
    private int _batch;
    private int _maxQueue;
    private long _timeout;

    protected ClientImpl(AbstractBayeux bayeux) {
        this._bayeux = bayeux;
        this._maxQueue = -1;
        this._bayeux.addClient(this, null);
        if (this._bayeux.isLogInfo()) {
            this._bayeux.logInfo("newClient: " + this);
        }
    }

    protected ClientImpl(AbstractBayeux bayeux, String idPrefix) {
        this._bayeux = bayeux;
        this._maxQueue = 0;
        this._bayeux.addClient(this, idPrefix);
        if (this._bayeux.isLogInfo()) {
            this._bayeux.logInfo("newClient: " + this);
        }
    }

    protected ClientImpl(AbstractBayeux bayeux, String idPrefix, Listener listener) {
        this(bayeux, idPrefix);
        this._listener = listener;
    }

    public void publish(String toChannel, Object data, String msgId) {
        this._bayeux.getChannel(toChannel).publish(this, data, msgId);
    }

    public void subscribe(String toChannel) {
        this._bayeux.subscribe(toChannel, this);
    }

    public void unsubscribe(String toChannel) {
        this._bayeux.unsubscribe(toChannel, this);
    }

    public void deliver(Client from, Message message) {
        for (Extension e : this._bayeux._extensions) {
            message = e.send(message);
        }
        this.doDelivery(from, message);
    }

    public void deliver(Client from, String toChannel, Object data, String id) {
        MessageImpl message = this._bayeux.newMessage();
        message.put("channel", toChannel);
        message.put("data", data);
        if (id != null) {
            message.put("id", id);
        }
        for (Extension e : this._bayeux._extensions) {
            message = e.send((Message)message);
        }
        this.doDelivery(from, message);
        message.decRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelivery(Client from, Message message) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            ((MessageImpl)message).incRef();
            if (this._maxQueue < 0) {
                this._messageQ = LazyList.add((Object)this._messageQ, (Object)message);
            } else if (this._maxQueue > 0) {
                if (LazyList.size((Object)this._messageQ) >= this._maxQueue) {
                    this._messageQ = LazyList.remove((Object)this._messageQ, (int)0);
                }
                this._messageQ = LazyList.add((Object)this._messageQ, (Object)message);
            }
            if (this._batch == 0 && this._responsesPending < 1) {
                this.resume();
            }
            if (this._mListeners != null) {
                for (MessageListener l : this._mListeners) {
                    l.deliver(from, (Client)this, message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBatch() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            ++this._batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (--this._batch == 0 && LazyList.size((Object)this._messageQ) > 0 && this._responsesPending < 1) {
                this.resume();
            }
        }
    }

    public String getConnectionType() {
        return this._type;
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return LazyList.size((Object)this._messageQ) > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJSONCommented() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return this._JSONCommented;
        }
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean timeout) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            Client client = this._bayeux.removeClient(this._id);
            if (this._bayeux.isLogInfo()) {
                this._bayeux.logInfo("Remove client " + client + " timeout=" + timeout);
            }
            if (this._rListeners != null) {
                for (RemoveListener l : this._rListeners) {
                    l.removed(this._id, timeout);
                }
            }
            if (this._browserId != null) {
                this._bayeux.clientOffBrowser(this.getBrowserId(), this._id);
            }
            this._browserId = null;
        }
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int responded() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return this._responsesPending--;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int responsePending() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return ++this._responsesPending;
        }
    }

    public void resume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJSONCommented(boolean commented) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._JSONCommented = commented;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(Listener listener) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (this._listener != null) {
                this.removeListener((EventListener)this._listener);
            }
            this._listener = listener;
            if (this._listener != null) {
                this.addListener((EventListener)this._listener);
            }
        }
    }

    public Listener getListener() {
        return this._listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessages() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return LazyList.size((Object)this._messageQ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> takeMessages() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            switch (LazyList.size((Object)this._messageQ)) {
                case 0: {
                    return null;
                }
                case 1: {
                    Message message = (Message)LazyList.get((Object)this._messageQ, (int)0);
                    this._messageQ = null;
                    return Collections.singletonList(message);
                }
            }
            List messages = LazyList.getList((Object)this._messageQ);
            this._messageQ = null;
            return messages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessages(List<Message> messages) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            switch (LazyList.size((Object)this._messageQ)) {
                case 0: {
                    this._messageQ = messages;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message takeMessage() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            switch (LazyList.size((Object)this._messageQ)) {
                case 0: {
                    return null;
                }
                case 1: {
                    Message message = (Message)LazyList.get((Object)this._messageQ, (int)0);
                    this._messageQ = null;
                    return message;
                }
            }
            Message message = (Message)LazyList.get((Object)this._messageQ, (int)0);
            this._messageQ = LazyList.remove((Object)this._messageQ, (int)0);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessage(Message message) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            switch (LazyList.size((Object)this._messageQ)) {
                case 0: {
                    this._messageQ = message;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public String toString() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscription(ChannelImpl channel) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._subscriptions = (ChannelImpl[])LazyList.addToArray((Object[])this._subscriptions, (Object)channel, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(ChannelImpl channel) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._subscriptions = (ChannelImpl[])LazyList.removeFromArray((Object[])this._subscriptions, (Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionType(String type) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setId(String _id) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._id = _id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeAll() {
        ChannelImpl[] subscriptions;
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._messageQ = null;
            subscriptions = this._subscriptions;
            this._subscriptions = new ChannelImpl[0];
        }
        for (ChannelImpl channel : subscriptions) {
            channel.unsubscribe(this);
        }
    }

    public void setBrowserId(String id) {
        if (this._browserId != null && !this._browserId.equals(id)) {
            this._bayeux.clientOffBrowser(this._browserId, this._id);
        }
        this._browserId = id;
        if (this._browserId != null) {
            this._bayeux.clientOnBrowser(this._browserId, this._id);
        }
    }

    public String getBrowserId() {
        return this._browserId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Client)) {
            return false;
        }
        return this.getId().equals(((Client)o).getId());
    }

    public int getAdviceVersion() {
        return this._adviseVersion;
    }

    public void setAdviceVersion(int version) {
        this._adviseVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EventListener listener) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (listener instanceof MessageListener) {
                if (this._mListeners == null) {
                    this._mListeners = new ArrayList<MessageListener>();
                }
                this._mListeners.add((MessageListener)listener);
            }
            if (listener instanceof RemoveListener) {
                if (this._rListeners == null) {
                    this._rListeners = new ArrayList<RemoveListener>();
                }
                this._rListeners.add((RemoveListener)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EventListener listener) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (listener instanceof MessageListener && this._mListeners != null) {
                this._mListeners.remove((MessageListener)listener);
            }
            if (listener instanceof RemoveListener && this._rListeners != null) {
                this._rListeners.remove((RemoveListener)listener);
            }
        }
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeoutMS) {
        this._timeout = timeoutMS;
    }
}

