/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.TextFunction;

public class Len
extends TextFunction {
    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval retval = null;
        String s = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 1: {
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcCellRow, srcCellCol);
                if (ve instanceof StringValueEval) {
                    StringValueEval sve = (StringValueEval)ve;
                    s = sve.getStringValue();
                    break;
                }
                if (ve instanceof RefEval) {
                    RefEval re = (RefEval)ve;
                    ValueEval ive = re.getInnerValueEval();
                    if (ive instanceof BlankEval) {
                        s = re.isEvaluated() ? "0" : null;
                        break;
                    }
                    if (ive instanceof StringValueEval) {
                        s = ((StringValueEval)ive).getStringValue();
                        break;
                    }
                    if (ive instanceof BlankEval) break;
                    retval = ErrorEval.VALUE_INVALID;
                    break;
                }
                if (ve instanceof BlankEval) break;
                retval = ErrorEval.VALUE_INVALID;
            }
        }
        if (retval == null) {
            s = s == null ? "" : s;
            retval = new NumberEval(s.length());
        }
        return retval;
    }

    protected ValueEval singleOperandEvaluate(Eval eval, int srcRow, short srcCol) {
        ValueEval retval;
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (ae.contains(srcRow, srcCol)) {
                retval = ErrorEval.CIRCULAR_REF_ERROR;
            } else if (ae.isRow()) {
                if (ae.containsColumn(srcCol)) {
                    ValueEval ve = ae.getValueAt(ae.getFirstRow(), srcCol);
                    retval = this.attemptXlateToText(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else if (ae.isColumn()) {
                if (ae.containsRow(srcRow)) {
                    ValueEval ve = ae.getValueAt(srcRow, ae.getFirstColumn());
                    retval = this.attemptXlateToText(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else {
                retval = ErrorEval.VALUE_INVALID;
            }
        } else {
            retval = this.attemptXlateToText((ValueEval)eval);
        }
        return retval;
    }

    protected ValueEval attemptXlateToText(ValueEval ve) {
        ValueEval retval = ve instanceof StringValueEval || ve instanceof RefEval ? ve : (ve instanceof BlankEval ? ve : ErrorEval.VALUE_INVALID);
        return retval;
    }
}

