/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.util.List;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UISearch;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UISearchForm.gtmpl", events={@EventConfig(listeners={QuickSearchActionListener.class})})
@Serialized
public class UISearchForm
extends UIForm {
    public static final String QUICK_SEARCH_SET = "QuickSearchSet";
    public static final String ADVANCED_SEARCH_SET = "AdvancedSearchSet";

    public UISearchForm() throws Exception {
        UIFormInputSet uiQuickSearchSet = new UIFormInputSet(QUICK_SEARCH_SET);
        uiQuickSearchSet.addUIFormInput(new UIFormStringInput("searchTerm", null, null));
        uiQuickSearchSet.addUIFormInput(new UIFormSelectBox("searchOption", null, null));
        this.addChild(uiQuickSearchSet);
        UIFormInputSet uiAdvancedSearchSet = new UIFormInputSet(ADVANCED_SEARCH_SET);
        this.addChild(uiAdvancedSearchSet);
        uiAdvancedSearchSet.setRendered(false);
    }

    public void setOptions(List<SelectItemOption<String>> options) {
        UIFormSelectBox uiSelect = (UIFormSelectBox)this.getQuickSearchInputSet().getChild(1);
        uiSelect.setOptions(options);
    }

    public UIFormInputSet getQuickSearchInputSet() {
        return (UIFormInputSet)this.getChild(0);
    }

    public UIFormInputSet getAdvancedSearchInputSet() {
        return (UIFormInputSet)this.getChild(1);
    }

    public void addAdvancedSearchInput(UIFormInput input) {
        this.getAdvancedSearchInputSet().addUIFormInput(input);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelAdvancedSearchActionListener
    extends EventListener<UISearchForm> {
        @Override
        public void execute(Event<UISearchForm> event) throws Exception {
            UISearchForm uiForm = event.getSource();
            UISearch uiSearch = (UISearch)uiForm.getParent();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSearch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowAdvancedSearchActionListener
    extends EventListener<UISearchForm> {
        @Override
        public void execute(Event<UISearchForm> event) throws Exception {
            UISearchForm uiForm = event.getSource();
            UISearch uiSearch = (UISearch)uiForm.getParent();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSearch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuickSearchActionListener
    extends EventListener<UISearchForm> {
        @Override
        public void execute(Event<UISearchForm> event) throws Exception {
            UISearchForm uiForm = event.getSource();
            UISearch uiSearch = (UISearch)uiForm.getParent();
            uiSearch.quickSearch(uiForm.getQuickSearchInputSet());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSearch);
        }
    }
}

