/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupXMLEntity
implements StreamingOutput {
    private final List<User> userList_;
    private final Group group_;
    private final String baseURI_;

    public GroupXMLEntity(Group group, List<User> userList, String baseURI) {
        this.userList_ = userList;
        this.group_ = group;
        this.baseURI_ = baseURI;
    }

    public void write(OutputStream out) throws IOException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(out);
            xsw.writeStartDocument();
            xsw.writeStartElement("group");
            xsw.writeDefaultNamespace("http://exoplatform.org/organization/rest");
            xsw.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
            xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/organization/group/" + "?output=xml&command=info&groupId=" + this.group_.getId().replaceFirst("/", ""));
            xsw.writeStartElement("id");
            xsw.writeCharacters(this.group_.getId());
            xsw.writeEndElement();
            xsw.writeStartElement("name");
            xsw.writeCharacters(this.group_.getGroupName());
            xsw.writeEndElement();
            xsw.writeStartElement("label");
            xsw.writeCharacters(this.group_.getLabel() != null ? this.group_.getLabel() : "");
            xsw.writeEndElement();
            xsw.writeStartElement("description");
            xsw.writeCharacters(this.group_.getDescription() != null ? this.group_.getDescription() : "");
            xsw.writeEndElement();
            xsw.writeStartElement("members");
            xsw.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
            for (User user : this.userList_) {
                xsw.writeStartElement("user");
                xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/organization/user/" + "?output=xml&command=info");
                xsw.writeCharacters(user.getUserName());
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

