/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.iptc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.sanselan.formats.jpeg.iptc.IPTCBlock;
import org.apache.sanselan.formats.jpeg.iptc.IPTCConstants;
import org.apache.sanselan.formats.jpeg.iptc.IPTCParser;
import org.apache.sanselan.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.sanselan.formats.jpeg.xmp.JpegRewriter;

public class JpegIptcRewriter
extends JpegRewriter
implements IPTCConstants {
    public void removeIPTC(File src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceFile byteSource = new ByteSourceFile(src);
        this.removeIPTC(byteSource, os);
    }

    public void removeIPTC(byte[] src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceArray byteSource = new ByteSourceArray(src);
        this.removeIPTC(byteSource, os);
    }

    public void removeIPTC(InputStream src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceInputStream byteSource = new ByteSourceInputStream(src, null);
        this.removeIPTC(byteSource, os);
    }

    public void removeIPTC(ByteSource byteSource, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        JpegRewriter.JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List oldPieces = jfifPieces.pieces;
        List photoshopApp13Segments = this.findPhotoshopApp13Segments(oldPieces);
        if (photoshopApp13Segments.size() > 1) {
            throw new ImageReadException("Image contains more than one Photoshop App13 segment.");
        }
        List newPieces = this.removePhotoshopApp13Segments(oldPieces);
        if (photoshopApp13Segments.size() == 1) {
            JpegRewriter.JFIFPieceSegment oldSegment = (JpegRewriter.JFIFPieceSegment)photoshopApp13Segments.get(0);
            HashMap params = new HashMap();
            PhotoshopApp13Data oldData = new IPTCParser().parsePhotoshopSegment(oldSegment.segmentData, params);
            List newBlocks = oldData.getNonIptcBlocks();
            ArrayList newRecords = new ArrayList();
            PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
            byte[] segmentBytes = new IPTCParser().writePhotoshopApp13Segment(newData);
            JpegRewriter.JFIFPieceSegment newSegment = new JpegRewriter.JFIFPieceSegment(oldSegment.marker, segmentBytes);
            newPieces.add(oldPieces.indexOf(oldSegment), newSegment);
        }
        this.writeSegments(os, newPieces);
    }

    public void writeIPTC(byte[] src, OutputStream os, PhotoshopApp13Data newData) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceArray byteSource = new ByteSourceArray(src);
        this.writeIPTC(byteSource, os, newData);
    }

    public void writeIPTC(InputStream src, OutputStream os, PhotoshopApp13Data newData) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceInputStream byteSource = new ByteSourceInputStream(src, null);
        this.writeIPTC(byteSource, os, newData);
    }

    public void writeIPTC(File src, OutputStream os, PhotoshopApp13Data newData) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceFile byteSource = new ByteSourceFile(src);
        this.writeIPTC(byteSource, os, newData);
    }

    public void writeIPTC(ByteSource byteSource, OutputStream os, PhotoshopApp13Data newData) throws ImageReadException, IOException, ImageWriteException {
        JpegRewriter.JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List oldPieces = jfifPieces.pieces;
        List photoshopApp13Segments = this.findPhotoshopApp13Segments(oldPieces);
        if (photoshopApp13Segments.size() > 1) {
            throw new ImageReadException("Image contains more than one Photoshop App13 segment.");
        }
        List newPieces = this.removePhotoshopApp13Segments(oldPieces);
        List newBlocks = newData.getNonIptcBlocks();
        byte[] newBlockBytes = new IPTCParser().writeIPTCBlock(newData.getRecords());
        int blockType = 1028;
        byte[] blockNameBytes = new byte[]{};
        IPTCBlock newBlock = new IPTCBlock(blockType, blockNameBytes, newBlockBytes);
        newBlocks.add(newBlock);
        newData = new PhotoshopApp13Data(newData.getRecords(), newBlocks);
        byte[] segmentBytes = new IPTCParser().writePhotoshopApp13Segment(newData);
        JpegRewriter.JFIFPieceSegment newSegment = new JpegRewriter.JFIFPieceSegment(65517, segmentBytes);
        newPieces = this.insertAfterLastAppSegments(newPieces, Arrays.asList(newSegment));
        this.writeSegments(os, newPieces);
    }
}

