/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.util.Calendar;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.server.WorkspaceRestoreExeption;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JobWorkspaceRestore
extends Thread {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.JobWorkspaceRestore");
    public static final int RESTORE_STARTED = 1;
    public static final int RESTORE_SUCCESSFUL = 2;
    public static final int RESTORE_FAIL = 3;
    public static final int RESTORE_INITIALIZED = 4;
    private int stateRestore;
    private final String repositoryName;
    private final WorkspaceEntry wEntry;
    private final RepositoryService repositoryService;
    private final BackupManager backupManager;
    private Throwable restoreException = null;
    private Calendar startTime;
    private Calendar endTime;
    private final BackupChainLog backupChainLog;

    public JobWorkspaceRestore(RepositoryService repositoryService, BackupManager backupManager, String repositoryName, BackupChainLog log, WorkspaceEntry wEntry) {
        this.repositoryService = repositoryService;
        this.backupManager = backupManager;
        this.repositoryName = repositoryName;
        this.backupChainLog = log;
        this.wEntry = wEntry;
        this.stateRestore = 4;
    }

    public void run() {
        try {
            this.stateRestore = 1;
            this.startTime = Calendar.getInstance();
            this.restore();
            this.stateRestore = 2;
            this.endTime = Calendar.getInstance();
        }
        catch (Throwable t) {
            this.stateRestore = 3;
            this.restoreException = t;
            log.error("The restore was fail", t);
        }
    }

    private void restore() throws Throwable {
        boolean restored = true;
        RepositoryImpl repository = (RepositoryImpl)this.repositoryService.getRepository(this.repositoryName);
        try {
            RepositoryEntry reEntry = repository.getConfiguration();
            this.backupManager.restore(this.backupChainLog, reEntry.getName(), this.wEntry, false);
        }
        catch (InvalidItemStateException e) {
            restored = false;
            throw new WorkspaceRestoreExeption("Workspace '/" + this.repositoryName + "/" + this.wEntry.getName() + "' can not be restored! There was database error!", e);
        }
        catch (Throwable t) {
            restored = false;
            throw new WorkspaceRestoreExeption("Workspace '/" + this.repositoryName + "/" + this.wEntry.getName() + "' can not be restored!", t);
        }
        finally {
            if (!restored) {
                try {
                    this.removeWorkspace((ManageableRepository)repository, this.wEntry.getName());
                }
                catch (Throwable thr) {
                    throw new WorkspaceRestoreExeption("Workspace '/" + this.repositoryName + "/" + this.wEntry.getName() + "' can not be restored!", thr);
                }
            }
        }
    }

    private void removeWorkspace(ManageableRepository mr, String workspaceName) throws RepositoryException {
        boolean isExists = false;
        for (String wsName : mr.getWorkspaceNames()) {
            if (!workspaceName.equals(wsName)) continue;
            isExists = true;
            break;
        }
        if (isExists) {
            if (!mr.canRemoveWorkspace(workspaceName)) {
                WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
                SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
                sessionRegistry.closeSessions(workspaceName);
            }
            mr.removeWorkspace(workspaceName);
        }
    }

    public Throwable getRestoreException() {
        return this.restoreException;
    }

    public int getStateRestore() {
        return this.stateRestore;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public BackupChainLog getBackupChainLog() {
        return this.backupChainLog;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getWorkspaceName() {
        return this.wEntry.getName();
    }

    public WorkspaceEntry getWorkspaceEntry() {
        return this.wEntry;
    }
}

