/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainChangesLogImpl
implements Externalizable,
PlainChangesLog {
    private static final int NULL_VALUE = -1;
    private static final int NOT_NULL_VALUE = 1;
    private static final long serialVersionUID = 5624550860372364084L;
    protected List<ItemState> items;
    protected String sessionId;
    protected int eventType;
    protected String pairId = null;

    public PlainChangesLogImpl(List<ItemState> items, String sessionId, int eventType, String pairId) {
        this.items = items;
        this.sessionId = sessionId;
        this.eventType = eventType;
        this.pairId = pairId;
    }

    public PlainChangesLogImpl(List<ItemState> items, String sessionId, int eventType) {
        this.items = items;
        this.sessionId = sessionId;
        this.eventType = eventType;
    }

    public PlainChangesLogImpl(List<ItemState> items, String sessionId) {
        this(items, sessionId, -1);
    }

    public PlainChangesLogImpl(String sessionId) {
        this(new ArrayList<ItemState>(), sessionId);
    }

    public PlainChangesLogImpl() {
        this(new ArrayList<ItemState>(), null);
    }

    @Override
    public List<ItemState> getAllStates() {
        return this.items;
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public PlainChangesLog add(ItemState change) {
        this.items.add(change);
        return this;
    }

    @Override
    public PlainChangesLog addAll(List<ItemState> changes) {
        this.items.addAll(changes);
        return this;
    }

    public void clear() {
        this.items.clear();
    }

    @Override
    public String getPairId() {
        return this.pairId;
    }

    @Override
    public String dump() {
        String str = "ChangesLog: \n";
        for (int i = 0; i < this.items.size(); ++i) {
            str = str + " " + ItemState.nameFromValue(this.items.get(i).getState()) + "\t" + this.items.get(i).getData().getIdentifier() + "\t" + "isPersisted=" + this.items.get(i).isPersisted() + "\t" + "isEventFire=" + this.items.get(i).isEventFire() + "\t" + "isInternallyCreated=" + this.items.get(i).isInternallyCreated() + "\t" + this.items.get(i).getData().getQPath().getAsString() + "\n";
        }
        return str;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.eventType);
        byte[] buff = this.sessionId.getBytes("UTF-8");
        out.writeInt(buff.length);
        out.write(buff);
        int listSize = this.items.size();
        out.writeInt(listSize);
        for (int i = 0; i < listSize; ++i) {
            out.writeObject(this.items.get(i));
        }
        if (this.pairId != null) {
            out.writeInt(1);
            buff = this.pairId.getBytes("UTF-8");
            out.writeInt(buff.length);
            out.write(buff);
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.eventType = in.readInt();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.sessionId = new String(buf, "UTF-8");
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.add((ItemState)in.readObject());
        }
        if (in.readInt() == 1) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.pairId = new String(buf, "UTF-8");
        }
    }
}

