/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.timeout;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.timeout.TimeoutExt;
import org.jboss.util.timeout.TimeoutPriorityQueue;
import org.jboss.util.timeout.TimeoutTarget;

public class HashedTimeoutPriorityQueueImpl
implements TimeoutPriorityQueue {
    private Object topLock = new Object();
    private TimeoutExtImpl top;
    private InternalPriorityQueue[] queues;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public HashedTimeoutPriorityQueueImpl() {
        this.queues = new InternalPriorityQueue[40];
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i] = new InternalPriorityQueue();
        }
    }

    public TimeoutExt offer(long time, TimeoutTarget target) {
        if (this.cancelled.get()) {
            throw new IllegalStateException("TimeoutPriorityQueue has been cancelled");
        }
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        if (target == null) {
            throw new IllegalArgumentException("Null timeout target");
        }
        TimeoutExtImpl timeout = new TimeoutExtImpl();
        timeout.time = time;
        timeout.target = target;
        int index = timeout.hashCode() % this.queues.length;
        return this.queues[index].offer(timeout);
    }

    public TimeoutExt take() {
        return this.poll(-1L);
    }

    public TimeoutExt poll() {
        return this.poll(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutExt poll(long wait) {
        long endWait = -1L;
        if (wait > 0L) {
            endWait = System.currentTimeMillis() + wait;
        }
        Object object = this.topLock;
        synchronized (object) {
            while (!(this.cancelled.get() || wait < 0L && endWait != -1L)) {
                block15: {
                    if (this.top == null) {
                        try {
                            if (endWait == -1L) {
                                this.topLock.wait();
                                break block15;
                            }
                            this.topLock.wait(wait);
                        }
                        catch (InterruptedException ex) {}
                    } else {
                        long now = System.currentTimeMillis();
                        if (this.top.time > now) {
                            long waitForFirst = this.top.time - now;
                            if (endWait != -1L && waitForFirst > wait) {
                                waitForFirst = wait;
                            }
                            try {
                                this.topLock.wait(waitForFirst);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                        }
                        if (!this.cancelled.get() && this.top != null && this.top.time <= System.currentTimeMillis()) {
                            TimeoutExtImpl result = this.top;
                            result.queue = null;
                            result.index = -2;
                            this.top = null;
                            this.recalculateTop(false);
                            return result;
                        }
                    }
                }
                if (endWait == -1L) continue;
                wait = endWait - System.currentTimeMillis();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutExt peek() {
        Object object = this.topLock;
        synchronized (object) {
            return this.top;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(TimeoutExt timeout) {
        TimeoutExtImpl timeoutImpl = (TimeoutExtImpl)timeout;
        InternalPriorityQueue queue = timeoutImpl.queue;
        if (queue != null && queue.remove(timeoutImpl)) {
            return true;
        }
        Object object = this.topLock;
        synchronized (object) {
            if (this.top == timeout) {
                this.top.done();
                this.top = null;
                this.recalculateTop(true);
                return true;
            }
            queue = timeoutImpl.queue;
            if (queue != null) {
                return queue.remove(timeoutImpl);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.topLock;
        synchronized (object) {
            if (this.cancelled.get()) {
                return;
            }
            for (int i = 1; i < this.queues.length; ++i) {
                this.queues[i].clear();
            }
            this.top = this.cleanupTimeoutExtImpl(this.top);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.topLock;
        synchronized (object) {
            if (this.cancelled.get()) {
                return;
            }
            this.clear();
            this.topLock.notifyAll();
        }
    }

    public int size() {
        int size = 0;
        if (this.top != null) {
            size = 1;
        }
        for (int i = 0; i < this.queues.length; ++i) {
            size += this.queues[i].size();
        }
        return size;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    private void recalculateTop(boolean notify) {
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i].compareAndSwapWithTop(notify);
        }
    }

    private TimeoutExtImpl cleanupTimeoutExtImpl(TimeoutExtImpl timeout) {
        if (timeout != null) {
            timeout.target = null;
        }
        return null;
    }

    private void assertExpr(boolean expr) {
        if (!expr) {
            throw new IllegalStateException("***** assert failed *****");
        }
    }

    public String dump() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("TOP=");
        if (this.top == null) {
            buffer.append("null");
        } else {
            buffer.append(this.top.time);
        }
        buffer.append(" size=").append(this.size()).append('\n');
        for (int i = 0; i < this.queues.length; ++i) {
            buffer.append(i).append("=");
            for (int j = 1; j <= this.queues[i].size; ++j) {
                buffer.append(((InternalPriorityQueue)this.queues[i]).queue[j].time).append(',');
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private class TimeoutExtImpl
    implements TimeoutExt {
        static final int TOP = 0;
        static final int DONE = -1;
        static final int TIMEOUT = -2;
        InternalPriorityQueue queue;
        int index;
        long time;
        TimeoutTarget target;

        private TimeoutExtImpl() {
        }

        public long getTime() {
            return this.time;
        }

        public TimeoutTarget getTimeoutTarget() {
            return this.target;
        }

        public void done() {
            this.queue = null;
            this.index = -1;
        }

        public boolean cancel() {
            return HashedTimeoutPriorityQueueImpl.this.remove(this);
        }
    }

    private class InternalPriorityQueue {
        private Object lock = new Object();
        private int size = 0;
        private TimeoutExtImpl[] queue = new TimeoutExtImpl[16];

        InternalPriorityQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TimeoutExt offer(TimeoutExtImpl timeout) {
            boolean checkTop = false;
            Object object = this.lock;
            synchronized (object) {
                if (++this.size == this.queue.length) {
                    TimeoutExtImpl[] newQ = new TimeoutExtImpl[2 * this.queue.length];
                    System.arraycopy(this.queue, 0, newQ, 0, this.queue.length);
                    this.queue = newQ;
                }
                this.queue[this.size] = timeout;
                timeout.queue = this;
                timeout.index = this.size;
                this.normalizeUp(this.size);
                if (timeout.index == 1) {
                    checkTop = true;
                }
            }
            if (checkTop) {
                object = HashedTimeoutPriorityQueueImpl.this.topLock;
                synchronized (object) {
                    this.compareAndSwapWithTop(true);
                }
            }
            return timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean compareAndSwapWithTop(boolean notify) {
            Object object = this.lock;
            synchronized (object) {
                if (this.size == 0) {
                    return false;
                }
                if (HashedTimeoutPriorityQueueImpl.this.top == null) {
                    HashedTimeoutPriorityQueueImpl.this.top = this.removeNode(1);
                    ((HashedTimeoutPriorityQueueImpl)HashedTimeoutPriorityQueueImpl.this).top.queue = null;
                    ((HashedTimeoutPriorityQueueImpl)HashedTimeoutPriorityQueueImpl.this).top.index = 0;
                    if (notify) {
                        HashedTimeoutPriorityQueueImpl.this.topLock.notify();
                    }
                    return HashedTimeoutPriorityQueueImpl.this.top != null;
                }
                if (((HashedTimeoutPriorityQueueImpl)HashedTimeoutPriorityQueueImpl.this).top.time > this.queue[1].time) {
                    TimeoutExtImpl temp = HashedTimeoutPriorityQueueImpl.this.top;
                    HashedTimeoutPriorityQueueImpl.this.top = this.queue[1];
                    ((HashedTimeoutPriorityQueueImpl)HashedTimeoutPriorityQueueImpl.this).top.queue = null;
                    ((HashedTimeoutPriorityQueueImpl)HashedTimeoutPriorityQueueImpl.this).top.index = 0;
                    this.queue[1] = temp;
                    temp.queue = this;
                    temp.index = 1;
                    if (this.size > 1) {
                        this.normalizeDown(1);
                    }
                    if (notify) {
                        HashedTimeoutPriorityQueueImpl.this.topLock.notify();
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(TimeoutExt timeout) {
            Object object = this.lock;
            synchronized (object) {
                TimeoutExtImpl timeoutImpl = (TimeoutExtImpl)timeout;
                if (timeoutImpl.queue == this && timeoutImpl.index > 0) {
                    this.removeNode(timeoutImpl.index);
                    timeoutImpl.queue = null;
                    timeoutImpl.index = -1;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                if (HashedTimeoutPriorityQueueImpl.this.cancelled.get()) {
                    return;
                }
                for (int i = 1; i <= this.size; ++i) {
                    this.queue[i] = HashedTimeoutPriorityQueueImpl.this.cleanupTimeoutExtImpl(this.queue[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.lock;
            synchronized (object) {
                if (HashedTimeoutPriorityQueueImpl.this.cancelled.get()) {
                    return;
                }
                this.clear();
            }
        }

        public int size() {
            return this.size;
        }

        private boolean normalizeUp(int index) {
            if (index == 1) {
                return false;
            }
            boolean ret = false;
            long t = this.queue[index].time;
            int p = index >> 1;
            while (this.queue[p].time > t) {
                this.swap(p, index);
                ret = true;
                if (p == 1) break;
                index = p;
                p >>= 1;
            }
            return ret;
        }

        void normalizeDown(int index) {
            long t = this.queue[index].time;
            int c = index << 1;
            while (c <= this.size) {
                TimeoutExtImpl l = this.queue[c];
                if (c + 1 <= this.size) {
                    TimeoutExtImpl r = this.queue[c + 1];
                    if (l.time <= r.time) {
                        if (t <= l.time) break;
                        this.swap(index, c);
                        index = c;
                    } else {
                        if (t <= r.time) break;
                        this.swap(index, c + 1);
                        index = c + 1;
                    }
                } else {
                    if (t <= l.time) break;
                    this.swap(index, c);
                    index = c;
                }
                c = index << 1;
            }
        }

        private void swap(int a, int b) {
            TimeoutExtImpl temp = this.queue[a];
            this.queue[a] = this.queue[b];
            this.queue[a].index = a;
            this.queue[b] = temp;
            this.queue[b].index = b;
        }

        private TimeoutExtImpl removeNode(int index) {
            TimeoutExtImpl res = this.queue[index];
            if (index == this.size) {
                --this.size;
                this.queue[index] = null;
                return res;
            }
            this.swap(index, this.size);
            --this.size;
            this.queue[res.index] = null;
            if (this.normalizeUp(index)) {
                return res;
            }
            this.normalizeDown(index);
            return res;
        }

        void checkTree() {
            HashedTimeoutPriorityQueueImpl.this.assertExpr(this.size >= 0);
            HashedTimeoutPriorityQueueImpl.this.assertExpr(this.size < this.queue.length);
            HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[0] == null);
            if (this.size > 0) {
                int i;
                HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[1] != null);
                HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[1].index == 1);
                HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[1].queue == this);
                for (i = 2; i <= this.size; ++i) {
                    HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i] != null);
                    HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i].index == i);
                    HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i].queue == this);
                    HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i >> 1].time <= this.queue[i].time);
                }
                for (i = this.size + 1; i < this.queue.length; ++i) {
                    HashedTimeoutPriorityQueueImpl.this.assertExpr(this.queue[i] == null);
                }
            }
        }
    }
}

