/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.renderers;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.webui.core.renderers.FormattableValueRenderer;
import org.exoplatform.webui.core.renderers.ValueRenderer;
import org.gatein.common.util.ParameterValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueRendererRegistry {
    private static Map<Class<?>, ValueRenderer<?>> DEFAULT_RENDERERS;
    private Map<Class<?>, ValueRenderer<?>> renderers;

    public <V> ValueRenderer<? super V> getRendererFor(V value) {
        if (value == null) {
            return ValueRenderer.NULL_RENDERER;
        }
        Class<?> valueType = value.getClass();
        ValueRenderer<?> renderer = this.getRendererFor(valueType);
        return renderer;
    }

    public <V> ValueRenderer<? super V> getRendererFor(Class<V> valueType) {
        if (valueType == null) {
            return ValueRenderer.NULL_RENDERER;
        }
        ValueRenderer<Object> renderer = ValueRendererRegistry.getRendererIn(valueType, this.renderers);
        if (renderer == null && (renderer = ValueRendererRegistry.getRendererIn(valueType, DEFAULT_RENDERERS)) == null) {
            for (Map.Entry<Class<?>, ValueRenderer<?>> entry : DEFAULT_RENDERERS.entrySet()) {
                Class<V> type = entry.getKey();
                if (!type.isAssignableFrom(valueType)) continue;
                ValueRenderer<?> tmp = entry.getValue();
                renderer = tmp;
                Class<V> asSubclassOfV = type;
                ValueRendererRegistry.registerDefaultRendererFor(renderer, asSubclassOfV);
                break;
            }
            if (renderer == null) {
                renderer = ValueRenderer.DEFAULT_RENDERER;
            }
        }
        return renderer;
    }

    public static <V> void registerDefaultRendererFor(ValueRenderer<? super V> renderer, Class<? extends V> type) {
        DEFAULT_RENDERERS = ValueRendererRegistry.registerIn(renderer, type, DEFAULT_RENDERERS);
    }

    public <V> void registerRendererFor(ValueRenderer<V> renderer, Class<? extends V> type) {
        this.renderers = ValueRendererRegistry.registerIn(renderer, type, this.renderers);
    }

    private static <V> Map<Class<?>, ValueRenderer<?>> registerIn(ValueRenderer<? super V> renderer, Class<? extends V> type, Map<Class<?>, ValueRenderer<?>> renderers) {
        ParameterValidation.throwIllegalArgExceptionIfNull(type, (String)"Value class");
        ParameterValidation.throwIllegalArgExceptionIfNull(renderer, (String)"Renderer");
        renderers = renderers == null ? new HashMap(7) : new HashMap(renderers);
        renderers.put(type, renderer);
        return renderers;
    }

    private static <V> ValueRenderer<? super V> getRendererIn(Class<V> valueType, Map<Class<?>, ValueRenderer<?>> renderers) {
        if (renderers == null) {
            return null;
        }
        ValueRenderer<?> renderer = renderers.get(valueType);
        return renderer;
    }

    static {
        ValueRendererRegistry.registerDefaultRendererFor(ValueRenderer.DEFAULT_RENDERER, String.class);
        FormattableValueRenderer numberRenderer = new FormattableValueRenderer(null, "number");
        ValueRendererRegistry.registerDefaultRendererFor(numberRenderer, Number.class);
        ValueRendererRegistry.registerDefaultRendererFor(numberRenderer, Byte.class);
        ValueRendererRegistry.registerDefaultRendererFor(numberRenderer, Double.class);
        ValueRendererRegistry.registerDefaultRendererFor(numberRenderer, Float.class);
        ValueRendererRegistry.registerDefaultRendererFor(numberRenderer, Integer.class);
        ValueRendererRegistry.registerDefaultRendererFor(numberRenderer, Long.class);
        ValueRendererRegistry.registerDefaultRendererFor(numberRenderer, Short.class);
        FormattableValueRenderer dateRenderer = new FormattableValueRenderer(new SimpleDateFormat("HH:mm:ss yyyy-MM-dd"), "Datetime");
        ValueRendererRegistry.registerDefaultRendererFor(dateRenderer, Date.class);
        ValueRendererRegistry.registerDefaultRendererFor(dateRenderer, java.sql.Date.class);
        ValueRendererRegistry.registerDefaultRendererFor(dateRenderer, Time.class);
        ValueRendererRegistry.registerDefaultRendererFor(dateRenderer, Timestamp.class);
    }
}

