/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.inject.ImplementedBy;
import java.util.logging.Logger;
import org.apache.shindig.protocol.RequestItem;

@ImplementedBy(value=NoOpHandler.class)
public interface HandlerExecutionListener {
    public void executing(String var1, String var2, RequestItem var3);

    public void executed(String var1, String var2, RequestItem var3);

    public static class LoggingHandler
    implements HandlerExecutionListener {
        public static final Logger LOG = Logger.getLogger(HandlerExecutionListener.class.toString());

        public void executing(String service, String operation, RequestItem request) {
            LOG.info("start - " + service + " " + operation);
        }

        public void executed(String service, String operation, RequestItem request) {
            LOG.info("  end - " + service + " " + operation);
        }
    }

    public static class NoOpHandler
    implements HandlerExecutionListener {
        public void executing(String service, String operation, RequestItem request) {
        }

        public void executed(String service, String operation, RequestItem request) {
        }
    }
}

