/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gatein.common.logging.Logger;
import org.gatein.pc.portlet.container.PortletInitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInstanceLifeCycle<T> {
    private Logger log;
    private Class<T> expectedClass;
    private ClassLoader classLoader;
    private String className;
    private String type;
    private T instance;

    public ClassInstanceLifeCycle(Logger log, Class<T> expectedClass, ClassLoader classLoader, String className, String type) {
        this.log = log;
        this.expectedClass = expectedClass;
        this.classLoader = classLoader;
        this.className = className;
        this.type = type;
    }

    public void create() throws PortletInitializationException {
        T instance;
        try {
            Class<?> clazz = this.classLoader.loadClass(this.className);
            if (!this.expectedClass.isAssignableFrom(clazz)) {
                String msg = "Cannot create " + this.type + " with class " + this.className + " because it does not implement the expected interface " + this.expectedClass.getName();
                throw new PortletInitializationException(msg);
            }
            Class<T> castedClass = clazz.asSubclass(this.expectedClass);
            Constructor<T> ctor = castedClass.getConstructor(new Class[0]);
            instance = ctor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            String msg = "Cannot create " + this.type + " with class " + this.className + " because the class contructor threw an exception";
            throw new PortletInitializationException(msg, e.getCause());
        }
        catch (IllegalAccessException e) {
            String msg = "Cannot create " + this.type + " with class " + this.className + " because the class is not accessible";
            throw new PortletInitializationException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "Cannot create " + this.type + " with class " + this.className + " because it does not have an no argument constructor";
            throw new PortletInitializationException(msg, e);
        }
        catch (ClassNotFoundException e) {
            String msg = "Cannot create " + this.type + " with class " + this.className + " because the class cannot be loaded";
            throw new PortletInitializationException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Cannot create " + this.type + " with class " + this.className + " because it cannot be instantiated";
            throw new PortletInitializationException(msg, e);
        }
        catch (Error e) {
            String msg = "Cannot create " + this.type + " with class " + this.className + " because of an error";
            throw new PortletInitializationException(msg, e);
        }
        ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.start(instance);
        }
        catch (Exception e) {
            String msg = "The " + this.type + " threw an exception during init";
            throw new PortletInitializationException(msg, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousLoader);
        }
        this.instance = instance;
    }

    public void destroy() {
        if (this.instance == null) {
            throw new IllegalStateException("No instance created previously");
        }
        try {
            this.stop(this.instance);
        }
        catch (Error e) {
            this.log.error((Object)("Stopping the " + this.type + " threw an error"), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)("Stopping the " + this.type + " threw an exception"), (Throwable)e);
        }
    }

    public T getInstance() {
        return this.instance;
    }

    protected void start(T instance) throws Exception {
    }

    protected void stop(T instance) {
    }
}

