/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gatein.common.i18n.LocaleFormat;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.util.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalizedString {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Logger log = LoggerFactory.getLogger(LocalizedString.class);
    private final Map<Locale, Value> values;
    private final Locale defaultLocale;
    private Integer hashCode;
    private String cachedToString;

    public LocalizedString(String defaultValue) throws IllegalArgumentException {
        this(defaultValue, Locale.ENGLISH);
    }

    public LocalizedString(String defaultValue, Locale defaultLocale) throws IllegalArgumentException {
        if (defaultValue == null) {
            throw new IllegalArgumentException("No null default value allowed");
        }
        if (defaultLocale == null) {
            throw new IllegalArgumentException("No null default locale allowed");
        }
        HashMap<Locale, Value> values = new HashMap<Locale, Value>(1);
        values.put(defaultLocale, new Value(defaultLocale, defaultValue));
        this.defaultLocale = defaultLocale;
        this.values = Collections.unmodifiableMap(values);
    }

    public LocalizedString(Locale defaultLocale) throws IllegalArgumentException {
        if (defaultLocale == null) {
            throw new IllegalArgumentException("No null default locale allowed");
        }
        this.defaultLocale = defaultLocale;
        this.values = Collections.emptyMap();
    }

    public LocalizedString(Map<Locale, String> values, Locale defaultLocale) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("No null description map allowed");
        }
        if (defaultLocale == null) {
            throw new IllegalArgumentException("No null default locale allowed");
        }
        HashMap<Locale, Value> tmp = new HashMap<Locale, Value>(values.size());
        for (Map.Entry<Locale, String> entry : values.entrySet()) {
            Locale key = entry.getKey();
            String value = entry.getValue();
            tmp.put(key, new Value(key, value));
        }
        this.defaultLocale = defaultLocale;
        this.values = Collections.unmodifiableMap(tmp);
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public String getDefaultString() {
        return this.getString(this.defaultLocale, false);
    }

    public Value getDefaultValue() {
        return this.getValue(this.defaultLocale, false);
    }

    public String getString(Locale locale, boolean resolve) {
        Value value = this.getValue(locale, resolve);
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    public Value getValue(Locale locale, boolean resolve) {
        if (locale == null) {
            throw new IllegalArgumentException("No null locale accepted as argument");
        }
        if (this.values.isEmpty()) {
            return null;
        }
        if (resolve) {
            Value value = this.values.get(locale);
            if (value == null && !locale.getVariant().equals("")) {
                value = this.values.get(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (value == null && !locale.getCountry().equals("")) {
                value = this.values.get(new Locale(locale.getLanguage()));
            }
            if (value == null) {
                value = this.values.get(this.defaultLocale);
            }
            return value;
        }
        return this.values.get(locale);
    }

    public Map<Locale, Value> getValues() {
        return this.values;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public String getMostAppropriateValueFor(String[] desiredLocales) throws IllegalArgumentException {
        Value mapping = this.getPreferredOrBestLocalizedMappingFor(desiredLocales);
        return mapping == null ? null : mapping.getString();
    }

    public Value getPreferredOrBestLocalizedMappingFor(String[] desiredLocales) throws IllegalArgumentException {
        if (desiredLocales == null) {
            throw new IllegalArgumentException("No null desired locale array accepted");
        }
        if (this.values.isEmpty()) {
            return null;
        }
        Value value = null;
        if (desiredLocales.length > 0) {
            for (int i = 0; value == null && i < desiredLocales.length; ++i) {
                String desiredLocale = desiredLocales[i];
                if (desiredLocale == null) {
                    throw new IllegalArgumentException("Null desired locale not accepted");
                }
                try {
                    Locale locale = LocaleFormat.RFC3066_LANGUAGE_TAG.getLocale(desiredLocale);
                    value = this.getValue(locale, true);
                    continue;
                }
                catch (ConversionException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Invalid desired locale " + desiredLocale));
                }
            }
        }
        if (value == null) {
            value = this.getValue(this.defaultLocale, true);
        }
        return value;
    }

    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = "LocalizedString[value='" + this.getMostAppropriateValueFor(EMPTY_STRINGS) + "',defaultLocale=" + this.getDefaultLocale() + "]";
        }
        return this.cachedToString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LocalizedString) {
            LocalizedString that = (LocalizedString)o;
            return this.defaultLocale.equals(that.defaultLocale) && this.getMostAppropriateValueFor(EMPTY_STRINGS).equals(that.getMostAppropriateValueFor(EMPTY_STRINGS));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = 31 * this.getMostAppropriateValueFor(EMPTY_STRINGS).hashCode() + this.defaultLocale.hashCode();
        }
        return this.hashCode;
    }

    public static class Value {
        private final Locale locale;
        private final String string;

        public Value(Locale locale, String string) throws IllegalArgumentException {
            if (locale == null) {
                throw new IllegalArgumentException();
            }
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.locale = locale;
            this.string = string;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getString() {
            return this.string;
        }
    }
}

