/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.util.IdGenerator;

public class TransientNodeData
extends TransientItemData
implements Comparable,
NodeData,
ItemData,
Externalizable {
    private static final long serialVersionUID = -8675118546441306180L;
    protected AccessControlList acl;
    protected InternalQName primaryTypeName;
    protected InternalQName[] mixinTypeNames;
    protected int orderNum;

    public TransientNodeData(QPath path, String identifier, int version, InternalQName primaryTypeName, InternalQName[] mixinTypeNames, int orderNum, String parentIdentifier, AccessControlList acl) {
        super(path, identifier, version, parentIdentifier);
        this.primaryTypeName = primaryTypeName;
        this.mixinTypeNames = mixinTypeNames;
        this.orderNum = orderNum;
        this.acl = acl;
    }

    public boolean isNode() {
        return true;
    }

    public int getOrderNumber() {
        return this.orderNum;
    }

    public InternalQName getPrimaryTypeName() {
        return this.primaryTypeName;
    }

    public InternalQName[] getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    public AccessControlList getACL() {
        return this.acl;
    }

    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        visitor.visit(this);
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, InternalQName[] mixinTypeNames, String identifier) {
        TransientNodeData nodeData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        nodeData = new TransientNodeData(path, identifier, -1, primaryTypeName, mixinTypeNames, 0, parent.getIdentifier(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName) {
        TransientNodeData nodeData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        nodeData = new TransientNodeData(path, IdGenerator.generate(), -1, primaryTypeName, new InternalQName[0], 0, parent.getIdentifier(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, InternalQName[] mixinTypesName) {
        TransientNodeData nodeData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        nodeData = new TransientNodeData(path, IdGenerator.generate(), -1, primaryTypeName, mixinTypesName, 0, parent.getIdentifier(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, int index) {
        TransientNodeData nodeData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name, index);
        nodeData = new TransientNodeData(path, IdGenerator.generate(), -1, primaryTypeName, new InternalQName[0], 0, parent.getIdentifier(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, int index, int orderNumber) {
        TransientNodeData nodeData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name, index);
        nodeData = new TransientNodeData(path, IdGenerator.generate(), -1, primaryTypeName, new InternalQName[0], orderNumber, parent.getIdentifier(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, String identifier) {
        TransientNodeData nodeData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        nodeData = new TransientNodeData(path, identifier, -1, primaryTypeName, new InternalQName[0], 0, parent.getIdentifier(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, String identifier, AccessControlList acl) {
        TransientNodeData nodeData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        nodeData = new TransientNodeData(path, identifier, -1, primaryTypeName, new InternalQName[0], 0, parent.getIdentifier(), acl);
        return nodeData;
    }

    public int compareTo(Object obj) {
        return ((NodeData)obj).getOrderNumber() - this.orderNum;
    }

    public TransientNodeData() {
        this.acl = new AccessControlList();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.orderNum);
        byte[] ptbuf = this.primaryTypeName.getAsString().getBytes("UTF-8");
        out.writeInt(ptbuf.length);
        out.write(ptbuf);
        out.writeInt(this.mixinTypeNames.length);
        for (int i = 0; i < this.mixinTypeNames.length; ++i) {
            byte[] buf = this.mixinTypeNames[i].getAsString().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
        this.acl.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        super.readExternal(in);
        this.orderNum = in.readInt();
        try {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.primaryTypeName = InternalQName.parse(new String(buf, "UTF-8"));
        }
        catch (IllegalNameException e) {
            throw new IOException(e.getMessage()){
                private static final long serialVersionUID = 3489809179234435267L;

                public Throwable getCause() {
                    return e;
                }
            };
        }
        int count = in.readInt();
        this.mixinTypeNames = new InternalQName[count];
        for (int i = 0; i < count; ++i) {
            try {
                buf = new byte[in.readInt()];
                in.readFully(buf);
                this.mixinTypeNames[i] = InternalQName.parse(new String(buf, "UTF-8"));
                continue;
            }
            catch (IllegalNameException e) {
                throw new IOException(e.getMessage()){
                    private static final long serialVersionUID = 3489809179234435268L;

                    public Throwable getCause() {
                        return e;
                    }
                };
            }
        }
        this.acl.readExternal(in);
    }
}

