/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.chromattic;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.Synchronization;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.jcr.RepositoryService;

public class ChromatticManager
implements ComponentRequestLifecycle {
    final RepositoryService repositoryService;
    Map<String, String> lifeCycleToWorkspaceMap;
    Map<String, ChromatticLifeCycle> lifeCycles = new HashMap<String, ChromatticLifeCycle>();
    private final ThreadLocal<Synchronization> currentSynchronization = new ThreadLocal();

    public ChromatticManager(RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
        this.lifeCycleToWorkspaceMap = new HashMap<String, String>();
    }

    public ChromatticLifeCycle getLifeCycle(String lifeCycleName) {
        return this.lifeCycles.get(lifeCycleName);
    }

    public void addLifeCycle(ComponentPlugin plugin) {
        ChromatticLifeCycle lifeCycle = (ChromatticLifeCycle)plugin;
        try {
            lifeCycle.manager = this;
            lifeCycle.start();
            this.lifeCycles.put(lifeCycle.getDomainName(), lifeCycle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Synchronization getSynchronization() {
        return this.currentSynchronization.get();
    }

    public void beginRequest() throws IllegalStateException {
        if (this.currentSynchronization.get() != null) {
            throw new IllegalStateException("Request already started");
        }
        Synchronization sync = new Synchronization();
        this.currentSynchronization.set(sync);
    }

    public void endRequest(boolean save) throws IllegalStateException {
        Synchronization sync = this.currentSynchronization.get();
        this.currentSynchronization.set(null);
        if (sync == null) {
            throw new IllegalStateException("Request not started");
        }
        sync.close(save);
        this.currentSynchronization.set(null);
    }

    public void startRequest(ExoContainer container) {
        this.beginRequest();
    }

    public void endRequest(ExoContainer container) {
        Synchronization sync = this.currentSynchronization.get();
        boolean save = sync.getSaveOnClose();
        this.endRequest(save);
    }
}

