/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.EmptySerializablePageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIPageIterator.gtmpl", events={@EventConfig(listeners={ShowPageActionListener.class})})
@Serialized
public class UIPageIterator
extends UIComponent {
    private PageList pageList_ = EmptySerializablePageList.get();
    private Set<String> selectedItems = new HashSet<String>();

    public void setPageList(PageList pageList) {
        this.pageList_ = pageList;
    }

    public PageList getPageList() {
        return this.pageList_;
    }

    public int getAvailablePage() {
        return this.pageList_.getAvailablePage();
    }

    public int getCurrentPage() {
        return this.pageList_.getCurrentPage();
    }

    public List getCurrentPageData() throws Exception {
        return this.pageList_.currentPage();
    }

    public int getAvailable() {
        return this.pageList_.getAvailable();
    }

    public int getFrom() {
        return this.pageList_.getFrom();
    }

    public int getTo() {
        return this.pageList_.getTo();
    }

    public Object getObjectInPage(int index) throws Exception {
        return this.pageList_.currentPage().get(index);
    }

    public void setCurrentPage(int page) throws Exception {
        this.pageList_.getPage(page);
    }

    public void setSelectedItem(String key, boolean value) {
        if (!value && this.selectedItems.contains(key)) {
            this.selectedItems.remove(key);
        } else if (value) {
            this.selectedItems.add(key);
        }
    }

    public Set<String> getSelectedItems() {
        return this.selectedItems;
    }

    public boolean isSelectedItem(String key) {
        return this.selectedItems.contains(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPageActionListener
    extends EventListener<UIPageIterator> {
        @Override
        public void execute(Event<UIPageIterator> event) throws Exception {
            UIPageIterator uiPageIterator = event.getSource();
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiPageIterator.setCurrentPage(page);
            UIPageIterator parent = uiPageIterator.getParent();
            if (parent == null) {
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(parent);
            parent.broadcast(event, event.getExecutionPhase());
        }
    }
}

